/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import oracle.eclipse.tools.coherence.descriptors.override.LoggingDestination;
import oracle.eclipse.tools.coherence.descriptors.override.internal.LoggingDestinationCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.LoggingDestinationFileNameCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.LoggingDestinationValidator;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public interface ILoggingConfig
extends Element {
    public static final ElementType TYPE = new ElementType(ILoggingConfig.class);
    @Type(base=LoggingDestination.class)
    @Label(standard="destination")
    @CustomXmlValueBinding(impl=LoggingDestinationCustomBinding.class, params={"destination"})
    @Services(value={@Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="logging-config/destination")}), @Service(impl=LoggingDestinationValidator.class)})
    @Documentation(content="Specifies the output device used by the logging system. [pbr/]Legal values are:[ul][li]stdout[/li][li]stderr[/li][li]jdk[/li][li]log4j[/li][li]slf4j[/li][li]a file name[/li][/ul]If \"jdk\" is specified as the destination, Coherence must be run using JDK 1.4 or later; likewise, if \"log4j\" or \"slf4j\" is specified, the corresponding logging libraries must be in the classpath. In all cases, the appropriate logging configuration mechanism (system properties, property files, etc.) should be used to configure the logging libraries.")
    public static final ValueProperty PROP_DESTINATION = new ValueProperty(TYPE, "Destination");
    @Label(standard="file")
    @CustomXmlValueBinding(impl=LoggingDestinationFileNameCustomBinding.class, params={"destination"})
    @Enablement(expr="${ Destination == 'filename' }")
    @Required
    public static final ValueProperty PROP_DESTINATION_FILE_NAME = new ValueProperty(TYPE, "DestinationFileName");
    @Label(standard="logger name")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"logger-name"})
    @Enablement(expr="${ Destination == 'jdk' || Destination == 'log4j' || Destination == 'slf4j' }")
    @DefaultValue(text="Coherence")
    @Documentation(content="Specifies a logger name within chosen logging system that should be used to log Coherence related messages.[pbr/]This value is only used by the jdk, log4j, slf4j logging systems.")
    public static final ValueProperty PROP_LOGGER_NAME = new ValueProperty(TYPE, "LoggerName");
    @Type(base=Integer.class)
    @Label(standard="level")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"severity-level"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="logging-config/severity-level")})
    @NumericRange(min="-1", max="9")
    @Documentation(content="Specifies which logged messages will be output to the log destination.[pbr/]Legal values are:[ul][li]0: only output without a logging severity level specified will be logged[/li][li]1: all the above plus errors[/li][li]2: all the above plus warnings[/li][li]3: all the above plus informational messages[/li][li]4-9: all the above plus internal debugging messages (the higher the number, the more the messages)[/li][li]-1: no messages[/li][/ul]")
    public static final ValueProperty PROP_SEVERITY_LEVEL = new ValueProperty(TYPE, "SeverityLevel");
    @Label(standard="message format")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"message-format"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="logging-config/message-format")})
    @Documentation(content="Specifies how messages that have a logging level specified will be formatted before passing them to the log destination.[pbr/]The value of the message-format element is static text with the following replaceable parameters:[pbr/]{date}       - the date/time format (to a millisecond) at which the message was logged[br/]{version}  - the Oracle Coherence exact version and build details[br/]{level}      - the logging severity level of the message[br/]{thread}    - the thread name that logged the message[br/]{member}    - the cluster member id (if the cluster is currently running)[br/]{location} - the fully qualified cluster member id: cluster-name, site-name, rack-name, machine-name, process-name and member-name (if the cluster is currently running)[br/]{role}        - the specified role of the cluster member[br/]{text}        - the text of the message")
    public static final ValueProperty PROP_MESSAGE_FORMAT = new ValueProperty(TYPE, "MessageFormat");
    @Type(base=Integer.class)
    @NamedValues(arbitraryValueLabel="character limit", defaultArbitraryValue="1048576", namedValues={@NamedValues.NamedValue(value="0", label="no limit")})
    @Label(standard="character limit")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"character-limit"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="logging-config/character-limit")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the maximum number of characters that the logger daemon will process from the message queue before discarding all remaining messages in the queue. Note that the message that caused the total number of characters to exceed the maximum will NOT be truncated, and all messages that are discarded will be summarized by the logging system with a single log entry detailing the number of messages that were discarded and their total size. The truncation of the logging is only temporary, since once the queue is processed (emptied), the logger is reset so that subsequent messages will be logged.[pbr/]The purpose of this setting is to avoid a situation where logging can itself prevent recovery from a failing condition. For example, with tight timings, logging can actually change the timings, causing more failures and probably more logging, which becomes a vicious cycle. A limit on the logging being done at any one point in time is a \"pressure valve\" that prevents such a vicious cycle from occurring. Note that logging occurs on a dedicated low-priority thread to even further reduce its impact on the critical portions of the system.")
    public static final ValueProperty PROP_CHARACTER_LIMIT = new ValueProperty(TYPE, "CharacterLimit");

    public Value<LoggingDestination> getDestination();

    public void setDestination(String var1);

    public void setDestination(LoggingDestination var1);

    public Value<String> getDestinationFileName();

    public void setDestinationFileName(String var1);

    public Value<String> getLoggerName();

    public void setLoggerName(String var1);

    public Value<Integer> getSeverityLevel();

    public void setSeverityLevel(String var1);

    public void setSeverityLevel(Integer var1);

    public Value<String> getMessageFormat();

    public void setMessageFormat(String var1);

    public Value<Integer> getCharacterLimit();

    public void setCharacterLimit(String var1);

    public void setCharacterLimit(Integer var1);
}

