/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import oracle.eclipse.tools.coherence.descriptors.override.IFilter;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemDefaultValueProvider;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;

@Label(standard="asymmetric encryption filter")
public interface IFilterClusterEncryption
extends IFilter {
    public static final ElementType TYPE = new ElementType(IFilterClusterEncryption.class);
    @Label(standard="key store")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(1)/param-value")})
    @Documentation(content="Specifies the path to the KeyStore")
    public static final ValueProperty PROP_STORE = new ValueProperty(TYPE, "Store");
    @Label(standard="key alias")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(2)/param-value")})
    @Documentation(content="Specifies the alias to use in reading the key from the keystore.")
    public static final ValueProperty PROP_KEY_ALIAS = new ValueProperty(TYPE, "KeyAlias");
    @Label(standard="key password")
    @Service(impl=ListItemDefaultValueProvider.class, params={@Service.Param(name="path", value="init-params/init-param(3)/param-value")})
    @Required
    @SensitiveData
    @Documentation(content="Specifies the password to use in reading the key.")
    public static final ValueProperty PROP_PASSWORD = new ValueProperty(TYPE, "Password");
    @PossibleValues(values={"JKS", "PKCS12"}, invalidValueSeverity=Status.Severity.OK)
    @Label(standard="store type")
    @DefaultValue(text="JKS")
    @Documentation(content="Specifies the type of KeyStore.")
    public static final ValueProperty PROP_STORE_TYPE = new ValueProperty(TYPE, "StoreType");
    @Label(standard="store password")
    @SensitiveData
    @Documentation(content="Specifies the password to use to access the store. [pbr/]If unspecified value of keyPassword parameter will be used.")
    public static final ValueProperty PROP_STORE_PASSWORD = new ValueProperty(TYPE, "StorePassword");
    @Label(standard="transformation")
    @DefaultValue(text="RSA/NONE/PKCS1Padding")
    @Documentation(content="Specifies the transformation to use.")
    public static final ValueProperty PROP_TRANSFORMATION = new ValueProperty(TYPE, "Transformation");
    @PossibleValues(values={"AES", "DES", "DESede", "PBEWithMD5AndDES", "PBEWithHmacSHA1AndDESede"}, invalidValueSeverity=Status.Severity.OK)
    @Label(standard="shared key type")
    @DefaultValue(text="DESede")
    @Documentation(content="Specifies the type of shared key.")
    public static final ValueProperty PROP_SHARED_KEY_TYPE = new ValueProperty(TYPE, "SharedKeyType");
    @Label(standard="shared key size")
    @Type(base=Integer.class)
    @NumericRange(min="0")
    @DefaultValue(text="112")
    @Documentation(content="Specifies the size of shared key.")
    public static final ValueProperty PROP_SHARED_KEY_SIZE = new ValueProperty(TYPE, "SharedKeySize");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @Label(standard="asymmetric filter class")
    @DefaultValue(text="com.tangosol.net.security.AsymmetricEncryptionFilter")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.security.AsymmetricEncryptionFilter"})
    @Documentation(content="Specifies the asymmetric filter implementation.")
    @MustExist
    public static final ValueProperty PROP_ASYMMETRIC_FILTER_CLASS_NAME = new ValueProperty(TYPE, "AsymmetricFilterClassName");

    public Value<String> getStore();

    public void setStore(String var1);

    public Value<String> getKeyAlias();

    public void setKeyAlias(String var1);

    public Value<String> getPassword();

    public void setPassword(String var1);

    public Value<String> getStoreType();

    public void setStoreType(String var1);

    public Value<String> getStorePassword();

    public void setStorePassword(String var1);

    public Value<String> getTransformation();

    public void setTransformation(String var1);

    public Value<String> getSharedKeyType();

    public void setSharedKeyType(String var1);

    public Value<Integer> getSharedKeySize();

    public void setSharedKeySize(String var1);

    public void setSharedKeySize(Integer var1);

    public ReferenceValue<JavaTypeName, JavaType> getAsymmetricFilterClassName();

    public void setAsymmetricFilterClassName(String var1);

    public void setAsymmetricFilterClassName(JavaTypeName var1);
}

