/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.override.IAuthorizedHosts;
import oracle.eclipse.tools.coherence.descriptors.override.IClusterQuorumPolicy;
import oracle.eclipse.tools.coherence.descriptors.override.IIncomingMessageHandler;
import oracle.eclipse.tools.coherence.descriptors.override.IJournalingConfig;
import oracle.eclipse.tools.coherence.descriptors.override.IOutgoingMessageHandler;
import oracle.eclipse.tools.coherence.descriptors.override.IPacketPublisher;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceGuardian;
import oracle.eclipse.tools.coherence.descriptors.override.ShutdownEnabled;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ShutdownEnabledCustomBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.VersionCompatibility;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IClusterConfigAdvanced
extends Element {
    public static final ElementType TYPE = new ElementType(IClusterConfigAdvanced.class);
    @Type(base=IPacketPublisher.class)
    @XmlBinding(path="packet-publisher")
    public static final ImpliedElementProperty PROP_PACKET_PUBLISHER = new ImpliedElementProperty(TYPE, "PacketPublisher");
    @Type(base=IIncomingMessageHandler.class)
    @XmlBinding(path="incoming-message-handler")
    public static final ImpliedElementProperty PROP_INCOMING_MESSAGE_HANDLER = new ImpliedElementProperty(TYPE, "IncomingMessageHandler");
    @Type(base=IOutgoingMessageHandler.class)
    @XmlBinding(path="outgoing-message-handler")
    public static final ImpliedElementProperty PROP_OUTGOING_MESSAGE_HANDLER = new ImpliedElementProperty(TYPE, "OutgoingMessageHandler");
    @Type(base=IAuthorizedHosts.class)
    @XmlBinding(path="authorized-hosts")
    public static final ImpliedElementProperty PROP_AUTHORIZED_HOSTS = new ImpliedElementProperty(TYPE, "AuthorizedHosts");
    @Type(base=Boolean.class)
    @Label(standard="enable TCP ring listener")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"tcp-ring-listener/enabled"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/tcp-ring-listener/enabled")})
    @Documentation(content="Specifies whether the tcp ring listener should be enabled to defect node failures faster.")
    public static final ValueProperty PROP_ENABLED = new ValueProperty(TYPE, "Enabled");
    @Type(base=Integer.class)
    @Label(standard="maximum socket closed exceptions")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"tcp-ring-listener/maximum-socket-closed-exceptions"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/tcp-ring-listener/maximum-socket-closed-exceptions")})
    @NumericRange(min="1")
    @Enablement(expr="${ Enabled }")
    @VersionCompatibility(value="3.5]")
    @Documentation(content="Specifies the maximum number of tcp ring listener exceptions that will be tolerated before a particular member is considered really gone and is removed from the cluster.")
    public static final ValueProperty PROP_MAXIMUM_SOCKET_CLOSED_EXCEPTIONS = new ValueProperty(TYPE, "MaximumSocketClosedExceptions");
    @Type(base=BigDecimal.class)
    @Label(standard="IP timeout")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"tcp-ring-listener/ip-timeout", "true", "15s"})
    @Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/tcp-ring-listener/ip-timeout"), @Service.Param(name="isNumber", value="true"), @Service.Param(name="default", value="15s")})
    @NumericRange(min="0")
    @Since(value="3.6")
    @Documentation(content="Specifies the timeout to use for determining that a machine hosting cluster members has become unreachable, and that those cluster members should be removed. The value should be high enough to insulate against allowable temporary network outages.")
    public static final ValueProperty PROP_IP_TIMEOUT = new ValueProperty(TYPE, "IpTimeout");
    @Type(base=TimeUnit.class)
    @Label(standard="IP timeout unit")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"tcp-ring-listener/ip-timeout", "false", "15s"})
    @Since(value="3.6")
    @Services(value={@Service(impl=NumberWithUnitDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/tcp-ring-listener/ip-timeout"), @Service.Param(name="isNumber", value="false"), @Service.Param(name="default", value="15s")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="IpTimeout")})})
    public static final ValueProperty PROP_IP_TIMEOUT_UNIT = new ValueProperty(TYPE, "IpTimeoutUnit");
    @Type(base=Integer.class)
    @Label(standard="IP attempts")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"tcp-ring-listener/ip-attempts"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/tcp-ring-listener/ip-attempts")})
    @NumericRange(min="1")
    @Since(value="3.6")
    public static final ValueProperty PROP_IP_ATTEMPTS = new ValueProperty(TYPE, "IpAttempts");
    @Type(base=Integer.class)
    @Label(standard="listen backlog")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"tcp-ring-listener/listen-backlog"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/tcp-ring-listener/listen-backlog")})
    @NumericRange(min="1")
    @Since(value="3.6")
    @Documentation(content="Specifies the size of the TCP/IP server socket backlog queue.")
    public static final ValueProperty PROP_LISTEN_BACKLOG = new ValueProperty(TYPE, "ListenBacklog");
    @Type(base=Integer.class)
    @Label(standard="priority")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"tcp-ring-listener/priority"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/tcp-ring-listener/priority")})
    @NumericRange(min="1", max="10")
    @Documentation(content="Specifies a priority of the tcp ring listener execution thread.")
    public static final ValueProperty PROP_PRIORITY = new ValueProperty(TYPE, "Priority");
    @Type(base=ShutdownEnabled.class)
    @Label(standard="enabled")
    @CustomXmlValueBinding(impl=ShutdownEnabledCustomBinding.class, params={"shutdown-listener/enabled"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/shutdown-listener/enabled")})
    @Documentation(content="Specifies the type of action to take upon an external JVM shutdown. [pbr/]Legal Values:[ul][li]none: perform no explicit shutdown actions[/li][li]force: perform \"hard-stop\" the node by calling Cluster.stop()[/li][li]graceful: perform a \"normal\" shutdown by calling Cluster.shutdown()[/li][/ul]")
    public static final ValueProperty PROP_SHUTDOWN_ENABLED = new ValueProperty(TYPE, "ShutdownEnabled");
    @Type(base=Integer.class)
    @NamedValues(arbitraryValueLabel="volume threshold", defaultArbitraryValue="32", namedValues={@NamedValues.NamedValue(value="0", label="always use the speaker")})
    @Label(standard="volume threshold (minimum packets)")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"packet-speaker/volume-threshold/minimum-packets"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-speaker/volume-threshold/minimum-packets"), @Service.Param(name="default", value="32")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the packet load which must be present for the speaker to be activated.")
    public static final ValueProperty PROP_VOLUME_THRESHOLD_MINIMUM_POCKETS = new ValueProperty(TYPE, "VolumeThresholdMinimumPockets");
    @Type(base=Integer.class)
    @Label(standard="priority")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"packet-speaker/priority"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-speaker/priority")})
    @NumericRange(min="1", max="10")
    @Documentation(content="Specifies a priority of the packet speaker execution thread.")
    public static final ValueProperty PROP_PACKET_SPEAKER_PRIORITY = new ValueProperty(TYPE, "PacketSpeakerPriority");
    @Type(base=Boolean.class)
    @Label(standard="enabled")
    @CustomXmlValueBinding(impl=OverrideValuePropertyCustomBinding.class, params={"packet-speaker/enabled"})
    @Service(impl=OverrideDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/packet-speaker/enabled")})
    @Since(value="12.1.2")
    public static final ValueProperty PROP_PACKET_SPEAKER_ENABLED = new ValueProperty(TYPE, "PacketSpeakerEnabled");
    @Type(base=IClusterQuorumPolicy.class)
    @XmlBinding(path="cluster-quorum-policy")
    @Since(value="3.6")
    public static final ImpliedElementProperty PROP_CLUSTER_QUORUM_POLICY = new ImpliedElementProperty(TYPE, "ClusterQuorumPolicy");
    @Type(base=IServiceGuardian.class)
    @XmlBinding(path="service-guardian")
    public static final ImpliedElementProperty PROP_SERVICE_GUARDIAN = new ImpliedElementProperty(TYPE, "ServiceGuardian");
    @Type(base=IJournalingConfig.class)
    @XmlBinding(path="journaling-config")
    @Since(value="3.7")
    public static final ImpliedElementProperty PROP_JOURNALING_CONFIG = new ImpliedElementProperty(TYPE, "JournalingConfig");

    public IPacketPublisher getPacketPublisher();

    public IIncomingMessageHandler getIncomingMessageHandler();

    public IOutgoingMessageHandler getOutgoingMessageHandler();

    public IAuthorizedHosts getAuthorizedHosts();

    public Value<Boolean> getEnabled();

    public void setEnabled(String var1);

    public void setEnabled(Boolean var1);

    public Value<Integer> getMaximumSocketClosedExceptions();

    public void setMaximumSocketClosedExceptions(String var1);

    public void setMaximumSocketClosedExceptions(Integer var1);

    public Value<BigDecimal> getIpTimeout();

    public void setIpTimeout(String var1);

    public void setIpTimeout(BigDecimal var1);

    public Value<TimeUnit> getIpTimeoutUnit();

    public void setIpTimeoutUnit(String var1);

    public void setIpTimeoutUnit(TimeUnit var1);

    public Value<Integer> getIpAttempts();

    public void setIpAttempts(String var1);

    public void setIpAttempts(Integer var1);

    public Value<Integer> getListenBacklog();

    public void setListenBacklog(String var1);

    public void setListenBacklog(Integer var1);

    public Value<Integer> getPriority();

    public void setPriority(String var1);

    public void setPriority(Integer var1);

    public Value<ShutdownEnabled> getShutdownEnabled();

    public void setShutdownEnabled(String var1);

    public void setShutdownEnabled(ShutdownEnabled var1);

    public Value<Integer> getVolumeThresholdMinimumPockets();

    public void setVolumeThresholdMinimumPockets(String var1);

    public void setVolumeThresholdMinimumPockets(Integer var1);

    public Value<Integer> getPacketSpeakerPriority();

    public void setPacketSpeakerPriority(String var1);

    public void setPacketSpeakerPriority(Integer var1);

    public Value<Boolean> getPacketSpeakerEnabled();

    public void setPacketSpeakerEnabled(String var1);

    public void setPacketSpeakerEnabled(Boolean var1);

    public IClusterQuorumPolicy getClusterQuorumPolicy();

    public IServiceGuardian getServiceGuardian();

    public IJournalingConfig getJournalingConfig();
}

