/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override;

import oracle.eclipse.tools.coherence.descriptors.override.ICoherenceOverride;
import oracle.eclipse.tools.coherence.internal.CoherencePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public final class CoherenceOverrideFactory {
    public static final String COHERENCE_OVERRIDE_XML = "tangosol-coherence-override.xml";

    public static ICoherenceOverride getCoherenceOverride(IProject project) {
        try {
            IPath srcPath = null;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3) {
                        srcPath = entry.getPath();
                        break;
                    }
                    ++n2;
                }
            }
            if (srcPath != null) {
                IPath filePath = srcPath.append(COHERENCE_OVERRIDE_XML);
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                if (file.exists()) {
                    return CoherenceOverrideFactory.getCoherenceOverride(file);
                }
            }
        }
        catch (JavaModelException e) {
            CoherencePlugin.log((Exception)((Object)e));
        }
        return null;
    }

    public static ICoherenceOverride getCoherenceOverride(IFile file) {
        try {
            return CoherenceOverrideFactory.getCoherenceOverride(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            CoherencePlugin.log((Exception)((Object)e));
            return null;
        }
    }

    public static ICoherenceOverride getCoherenceOverride(XmlResourceStore xmlResourceStore) {
        return (ICoherenceOverride)ICoherenceOverride.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
    }
}

