/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.operations.internal;

import oracle.eclipse.tools.coherence.descriptors.operations.IGarExportWizardOp;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.archive.operations.JavaEEComponentExportOperation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class GarExportMethods {
    public static Status execute(IGarExportWizardOp operation, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        monitor.beginTask(Resources.executeTaskName, 3);
        try {
            try {
                String projectName = (String)operation.getProject().content();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                Path folder = (Path)operation.getFolder().content();
                boolean exportSource = (Boolean)operation.getExportSourceFiles().content();
                boolean overwrite = (Boolean)operation.getOverwriteExistingFile().content();
                IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentExportDataModelProvider());
                model.setStringProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", projectName);
                model.setStringProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", folder.toOSString());
                model.setBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", exportSource);
                model.setBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", overwrite);
                IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
                model.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", (Object)comp);
                JavaEEComponentExportOperation exportOp = new JavaEEComponentExportOperation(model);
                exportOp.execute(ProgressMonitorBridge.create((ProgressMonitor)monitor), null);
                monitor.worked(1);
            }
            catch (ExecutionException e) {
                Status status = Status.createErrorStatus((Throwable)e);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String executeTaskName;

        static {
            Resources.initializeMessages((String)GarExportMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

