/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.launchConfig.internal;

import oracle.eclipse.tools.coherence.descriptors.launchConfig.CoherenceModel;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.ISystemProperty;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;

public final class SystemPropertyResource
extends Resource {
    private CoherenceModel model;
    private String name;

    public SystemPropertyResource(CoherenceModel model, String name) {
        super(null);
        this.model = model;
        this.name = name;
    }

    public CoherenceModel getCoherenceModel() {
        return this.model;
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == ISystemProperty.PROP_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return SystemPropertyResource.this.name;
                }

                public void write(String value) {
                    SystemPropertyResource.this.name = value;
                }
            };
        }
        if (p == ISystemProperty.PROP_VALUE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return SystemPropertyResource.this.getCoherenceModel().getValue(SystemPropertyResource.this.name);
                }

                public void write(String value) {
                    SystemPropertyResource.this.getCoherenceModel().setValue(SystemPropertyResource.this.name, value);
                }
            };
        }
        throw new IllegalArgumentException();
    }
}

