/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.launchConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.ManagementOption;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.RefreshOption;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigEnabler;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigListener;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigValidator;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.RefreshUnitDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.RefreshUnitValidator;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;

public interface IJmxConfig
extends Element {
    public static final ElementType TYPE = new ElementType(IJmxConfig.class);
    public static final String MANAGEMENT_NAME = "Management";
    public static final String REMOTE_MANAGEMENT_NAME = "RemoteManagement";
    public static final String READONLY_MANAGEMENT_NAME = "ReadonlyManagement";
    public static final String HOST_NAME = "Host";
    public static final String REGISTRY_PORT_NAME = "RegistryPort";
    public static final String REGISTRY_CONNECTION_NAME = "RegistryConnection";
    public static final String HTTP_PORT_NAME = "HttpPort";
    public static final String REFRESH_EXPIRY_NAME = "RefreshExpiry";
    public static final String REFRESH_EXPIRY_UNITS_NAME = "RefreshExpiryUnits";
    public static final String REFRESH_OPTION_NAME = "RefreshOption";
    @Type(base=ManagementOption.class)
    @Label(standard="&management")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Specifies whether or not a cluster node's JVM has an [in-process] MBeanServer and if so, whether or not this node allows management of other nodes' managed objects.[pbr/]Legal values are:[ul][li]none: No MBeanServer is instantiated.[/li][li]local-only: Manage only MBeans which are local to the cluster node (i.e. within the same JVM).[/li][li]remote-only: Manage MBeans on other remotely manageable cluster nodes. Requires Coherence Enterprise Edition or higher.[/li][li]all: Manage both local and remotely manageable cluster nodes. Requires Coherence Enterprise Edition or higher.[/li][/ul]")
    public static final ValueProperty PROP_MANAGEMENT = new ValueProperty(TYPE, "Management");
    @Type(base=Boolean.class)
    @Label(standard="&enable remote management")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Specifies whether or not this cluster node exposes its managed objects to remote MBeanServer(s).")
    public static final ValueProperty PROP_REMOTE_MANAGEMENT = new ValueProperty(TYPE, "RemoteManagement");
    @Type(base=Boolean.class)
    @Label(standard="manage &read-only")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Specifies whether or not the managed objects exposed by this cluster node allow operations that modify run-time attributes.")
    public static final ValueProperty PROP_READONLY_MANAGEMENT = new ValueProperty(TYPE, "ReadonlyManagement");
    @Label(standard="&host")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="The host that the JMX server will bind to. Default is localhost. (NOTE: on Redhat Linux this may have to be changed to the host name or IP address)")
    public static final ValueProperty PROP_HOST = new ValueProperty(TYPE, "Host");
    @Type(base=Integer.class)
    @Label(standard="registry &port")
    @Listeners(value={LaunchConfigListener.class})
    @NumericRange(min="1", max="65535")
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="The port used for the JMX RMI registry.")
    public static final ValueProperty PROP_REGISTRY_PORT = new ValueProperty(TYPE, "RegistryPort");
    @Type(base=Integer.class)
    @Label(standard="re&gistry connection")
    @Listeners(value={LaunchConfigListener.class})
    @NumericRange(min="1", max="65535")
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="The port used for the JMX RMI connection.")
    public static final ValueProperty PROP_REGISTRY_CONNECTION = new ValueProperty(TYPE, "RegistryConnection");
    @Type(base=Integer.class)
    @Label(standard="H&TTP port")
    @Listeners(value={LaunchConfigListener.class})
    @NumericRange(min="1", max="65535")
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="The port used for the HTTP connection.")
    public static final ValueProperty PROP_HTTP_PORT = new ValueProperty(TYPE, "HttpPort");
    @Type(base=BigDecimal.class)
    @Label(standard="re&fresh expiry")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=RefreshUnitValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=RefreshUnitDefaultValueProvider.class)})
    @Documentation(content="Specifies the minimum time interval between the remote retrieval of management information from remote nodes.")
    public static final ValueProperty PROP_REFRESH_EXPIRY = new ValueProperty(TYPE, "RefreshExpiry");
    @Type(base=TimeUnit.class)
    @Label(standard="refresh expiry units")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=RefreshUnitValidator.class), @Service(impl=LaunchConfigEnabler.class, params={@Service.Param(name="property", value="RefreshExpiry")}), @Service(impl=RefreshUnitDefaultValueProvider.class)})
    @Documentation(content="Specifies the minimum time interval between the remote retrieval of management information from remote nodes.")
    public static final ValueProperty PROP_REFRESH_EXPIRY_UNITS = new ValueProperty(TYPE, "RefreshExpiryUnits");
    @Type(base=RefreshOption.class)
    @Label(standard="refresh &option")
    @Listeners(value={LaunchConfigListener.class})
    @Services(value={@Service(impl=LaunchConfigValidator.class), @Service(impl=LaunchConfigEnabler.class), @Service(impl=LaunchConfigDefaultValueProvider.class)})
    @Documentation(content="Defines the refresh policy for the MBean.[pbr/]Valid values for this property are:[ul][li]refresh-expired: This setting has the same functionality as in pre-3.4 Coherence releases. Each MBean will be refreshed from the remote node when it is accessed and the expiry delay has passed from the last refresh. This setting is best used when MBeans are accessed in a random pattern.[br/][/li][li]refresh-ahead: MBeans are refreshed before they are requested based on prior usage patterns after the expiry delay has passed. This setting can reduce latency of the management information with a minor increase in network consumption. This setting is best when MBeans are accessed in a repetitive/programmatic pattern.[br/][/li][li]refresh-behind: Each MBean will be refreshed after the data is accessed. This method ensures optimal response time. However, the information returned will be offset by the last refresh time.[br/][/li][/ul]")
    public static final ValueProperty PROP_REFRESH_OPTION = new ValueProperty(TYPE, "RefreshOption");

    public Value<ManagementOption> getManagement();

    public void setManagement(String var1);

    public void setManagement(ManagementOption var1);

    public Value<Boolean> getRemoteManagement();

    public void setRemoteManagement(String var1);

    public void setRemoteManagement(Boolean var1);

    public Value<Boolean> getReadonlyManagement();

    public void setReadonlyManagement(String var1);

    public void setReadonlyManagement(Boolean var1);

    public Value<String> getHost();

    public void setHost(String var1);

    public Value<Integer> getRegistryPort();

    public void setRegistryPort(String var1);

    public void setRegistryPort(Integer var1);

    public Value<Integer> getRegistryConnection();

    public void setRegistryConnection(String var1);

    public void setRegistryConnection(Integer var1);

    public Value<Integer> getHttpPort();

    public void setHttpPort(String var1);

    public void setHttpPort(Integer var1);

    public Value<BigDecimal> getRefreshExpiry();

    public void setRefreshExpiry(String var1);

    public void setRefreshExpiry(BigDecimal var1);

    public Value<TimeUnit> getRefreshExpiryUnits();

    public void setRefreshExpiryUnits(String var1);

    public void setRefreshExpiryUnits(TimeUnit var1);

    public Value<RefreshOption> getRefreshOption();

    public void setRefreshOption(String var1);

    public void setRefreshOption(RefreshOption var1);
}

