/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.launchConfig;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.coherence.descriptors.CoherenceException;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.SystemPropertyModel;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CoherenceModel {
    private IJavaProject javaProject = null;
    private File workingDir = null;
    private List<SystemPropertyModel> overrideList = new ArrayList<SystemPropertyModel>();
    private Map<String, String> values = new HashMap<String, String>();
    private List<SystemPropertyModel> cacheConfigList = new ArrayList<SystemPropertyModel>();
    private String cacheConfigName = null;
    private Map<String, String> vmArgumentMap;
    private final ListenerContext listeners = new ListenerContext();
    private static final String SYSTEM_PROPERTY = "system-property";
    private static final String ID = "id";
    private static final String ATTR_OVERRIDE = "xml-override";
    private static final String FILE_CFG_COHERENCE = "tangosol-coherence.xml";
    private static final String FILE_CFG_COHERENCE_OVERRIDE = "tangosol-coherence-override.xml";
    private static final String[] TOOLED_SYSTEM_PROPERTIES = new String[]{"CacheConfig", "LocalStorage", "Log", "LoggerName", "LogLevel", "LogLimit", "ClusterAddress", "ClusterPort", "Ttl", "Wka", "WkaPort", "Management", "RemoteManagement", "ReadonlyManagement", "Host", "RegistryConnection", "RegistryPort", "HttpPort", "RefreshExpiry", "RefreshOption"};

    public void propertyChanged() {
    }

    public void clear() {
        this.overrideList.clear();
        this.javaProject = null;
        this.workingDir = null;
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public Set<String> getKeySet() {
        return this.values.keySet();
    }

    public String getValue(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key);
        }
        return null;
    }

    public void setValue(String key, String value) {
        if (value == null) {
            this.values.remove(key);
        } else {
            this.values.put(key, value);
        }
    }

    public void clearValues() {
        this.values.clear();
    }

    public List<String> getSystemProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<String> tooled = new ArrayList<String>();
        String[] stringArray = TOOLED_SYSTEM_PROPERTIES;
        int n = TOOLED_SYSTEM_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            tooled.add(this.getSystemProperty(str));
            ++n2;
        }
        for (SystemPropertyModel prop : this.overrideList) {
            String name = prop.getSystemProperty();
            if (name == null || name.length() <= 0 || tooled.contains(name) || properties.contains(name)) continue;
            properties.add(name);
        }
        this.getCacheConfigList();
        for (SystemPropertyModel prop : this.cacheConfigList) {
            String name = prop.getSystemProperty();
            if (name == null || name.length() <= 0 || properties.contains(name)) continue;
            properties.add(name);
        }
        Collections.sort(properties);
        return properties;
    }

    public String getDefaultValue(String key) {
        SystemPropertyModel prop = this.getSystemPropertyModel(key);
        if (prop != null) {
            return prop.getDefaultValue();
        }
        return null;
    }

    public boolean isDefaultFromVmArgs(String key) {
        SystemPropertyModel prop = this.getSystemPropertyModel(key);
        if (prop != null) {
            return prop.isDefaultFromVmArguments();
        }
        return false;
    }

    public String getSystemProperty(String key) {
        SystemPropertyModel prop;
        if ("LogFileName".equals(key)) {
            key = "Log";
        }
        if ((prop = this.getSystemPropertyModel(key)) != null) {
            return prop.getSystemProperty();
        }
        return null;
    }

    private SystemPropertyModel getSystemPropertyModel(String key) {
        String xpath = null;
        if ("CacheConfig".equals(key)) {
            xpath = "configurable-cache-factory-config/init-params/init-param/param-value";
        } else if ("LocalStorage".equals(key)) {
            xpath = "cluster-config/services/service(3)/init-params/init-param(4)/param-value";
        } else if ("Log".equals(key)) {
            xpath = "logging-config/destination";
        } else if ("LoggerName".equals(key)) {
            xpath = "logging-config/logger-name";
        } else if ("LogLevel".equals(key)) {
            xpath = "logging-config/severity-level";
        } else if ("LogLimit".equals(key)) {
            xpath = "logging-config/character-limit";
        } else if ("ClusterAddress".equals(key)) {
            xpath = "cluster-config/multicast-listener/address";
        } else if ("ClusterPort".equals(key)) {
            xpath = "cluster-config/multicast-listener/port";
        } else if ("Ttl".equals(key)) {
            xpath = "cluster-config/multicast-listener/time-to-live";
        } else if ("Wka".equals(key)) {
            xpath = "cluster-config/unicast-listener/well-known-addresses/socket-address(1)/address";
        } else if ("WkaPort".equals(key)) {
            xpath = "cluster-config/unicast-listener/well-known-addresses/socket-address(1)/port";
        } else if ("Management".equals(key)) {
            xpath = "management-config/managed-nodes";
        } else if ("RemoteManagement".equals(key)) {
            xpath = "management-config/allow-remote-management";
        } else if ("ReadonlyManagement".equals(key)) {
            xpath = "management-config/read-only";
        } else if ("RefreshExpiry".equals(key)) {
            xpath = "management-config/refresh-expiry";
        } else if ("RefreshOption".equals(key)) {
            xpath = "management-config/refresh-policy";
        } else if ("Host".equals(key)) {
            key = "tangosol.coherence.management.remote.host";
        } else if ("RegistryPort".equals(key)) {
            key = "tangosol.coherence.management.remote.registryport";
        } else if ("RegistryConnection".equals(key)) {
            key = "tangosol.coherence.management.remote.connectionport";
        } else if ("HttpPort".equals(key)) {
            key = "tangosol.coherence.management.remote.httpport";
        }
        if (xpath != null) {
            SystemPropertyModel prop = this.getSystemPropertyModelFromXpath(xpath);
            if (prop != null) {
                return prop;
            }
        } else {
            SystemPropertyModel prop = this.getSystemPropertyModelFromSystemProperty(key);
            if (prop != null) {
                return prop;
            }
            prop = this.getCacheConfigSystemProperty(key);
            if (prop != null) {
                return prop;
            }
        }
        return null;
    }

    private String getKey(String systemProperty) {
        String[] stringArray = TOOLED_SYSTEM_PROPERTIES;
        int n = TOOLED_SYSTEM_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (systemProperty.equals(this.getSystemProperty(key))) {
                return key;
            }
            ++n2;
        }
        for (SystemPropertyModel prop : this.overrideList) {
            if (!systemProperty.equals(prop.getSystemProperty())) continue;
            return systemProperty;
        }
        return null;
    }

    private String calculateAttribute(String sAttr) {
        if (sAttr.indexOf("{mode}") >= 0) {
            sAttr = StringUtil.replaceAll((String)sAttr, (String)"{mode}", (String)"dev");
        }
        while (sAttr.startsWith("{") && sAttr.endsWith("}")) {
            String sDefault;
            String sPropName;
            int ofDefault = sAttr.indexOf(32);
            int cchLength = sAttr.length();
            if (ofDefault < 0) {
                sDefault = sPropName = sAttr.substring(1, cchLength - 1);
            } else {
                sPropName = sAttr.substring(1, ofDefault);
                sDefault = sAttr.substring(ofDefault + 1, cchLength - 1);
            }
            sAttr = this.vmArgumentMap.containsKey(sPropName) ? this.vmArgumentMap.get(sPropName) : sDefault;
        }
        return sAttr;
    }

    public void parse(String[] classpaths, String vmArguments) throws CoherenceException {
        ArrayList<URL> urls = new ArrayList<URL>();
        String[] stringArray = classpaths;
        int n = classpaths.length;
        int n2 = 0;
        while (n2 < n) {
            String classpath = stringArray[n2];
            File file = new File(classpath);
            if (file.exists()) {
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.coherence", (Throwable)e);
                }
            }
            ++n2;
        }
        URLClassLoader loader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]));
        String[] arguments = DebugPlugin.parseArguments((String)vmArguments);
        this.vmArgumentMap = new HashMap<String, String>();
        String[] e = arguments;
        int file = arguments.length;
        int n3 = 0;
        while (n3 < file) {
            int equalIndex;
            String argument = e[n3];
            if (argument.startsWith("-D") && (equalIndex = argument.indexOf("=")) > 0) {
                String key = argument.substring(2, equalIndex);
                String value = argument.substring(equalIndex + 1, argument.length());
                this.vmArgumentMap.put(key.trim(), value.trim());
            }
            ++n3;
        }
        String override = FILE_CFG_COHERENCE;
        while (override != null && override.length() > 0) {
            File file2 = new File(override);
            if (file2.exists() && file2.isDirectory()) {
                file2 = new File(file2, FILE_CFG_COHERENCE_OVERRIDE);
            }
            if (file2.exists()) {
                String attr = this.parse(file2);
                override = this.calculateAttribute(attr);
                continue;
            }
            InputStream stream = loader.getResourceAsStream(override);
            if (stream == null && override.startsWith("/")) {
                override = override.substring(1);
                stream = loader.getResourceAsStream(override);
            }
            if (stream != null) {
                String attr = this.parse(stream);
                override = this.calculateAttribute(attr);
                continue;
            }
            override = null;
        }
        this.addSystemProperty(null, "tangosol.coherence.management.remote.host", "localhost");
        this.addSystemProperty(null, "tangosol.coherence.management.remote.registryport", "9000");
        this.addSystemProperty(null, "tangosol.coherence.management.remote.connectionport", "3000");
        this.addSystemProperty(null, "tangosol.coherence.management.remote.httpport", "8888");
        for (String systemProperty : this.vmArgumentMap.keySet()) {
            String key = this.getKey(systemProperty);
            if (key == null) continue;
            String defaultValue = this.vmArgumentMap.get(systemProperty);
            SystemPropertyModel model = this.getSystemPropertyModel(key);
            model.setDefaultValue(defaultValue, true);
        }
        this.listeners.broadcast((Event)new ModelChangedEvent());
    }

    private SystemPropertyModel getCacheConfigSystemProperty(String key) {
        for (SystemPropertyModel model : this.cacheConfigList) {
            if (!key.equals(model.getSystemProperty())) continue;
            return model;
        }
        return null;
    }

    private void getCacheConfigList() {
        String cacheConfigFile;
        String value = this.getValue("CacheConfig");
        String string = cacheConfigFile = value != null ? value : this.getDefaultValue("CacheConfig");
        if (ObjectUtil.equal((Object)this.cacheConfigName, (Object)cacheConfigFile)) {
            return;
        }
        this.cacheConfigList = new ArrayList<SystemPropertyModel>();
        this.cacheConfigName = cacheConfigFile;
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null && cacheConfigFile != null) {
            try {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3) {
                        IPath srcPath = entry.getPath();
                        IPath filePath = srcPath.append(cacheConfigFile);
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                        if (file.exists()) {
                            Document doc = DomUtil.doc((InputStream)file.getContents());
                            this.parseCacheConfig(doc.getDocumentElement(), null);
                            break;
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.coherence", (CoreException)((Object)e));
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.coherence", (CoreException)e);
            }
        }
    }

    private void parseCacheConfig(Element parent, String parentName) {
        for (Element element : DomUtil.elements((Element)parent)) {
            String xpath = DomUtil.basename((String)element.getNodeName());
            if (parentName != null) {
                StringBuffer buf = new StringBuffer(parentName);
                buf.append("/");
                buf.append(xpath);
                String id = element.getAttribute(ID);
                if (id != null && id.length() > 0) {
                    buf.append("(");
                    buf.append(id);
                    buf.append(")");
                }
                xpath = buf.toString();
            }
            String systemProperty = element.getAttribute(SYSTEM_PROPERTY);
            String value = DomUtil.text((Node)element);
            String string = value = value == null ? null : value.trim();
            if (systemProperty != null && systemProperty.length() > 0) {
                SystemPropertyModel model = new SystemPropertyModel(xpath, systemProperty, value);
                this.cacheConfigList.add(model);
            }
            this.parseCacheConfig(element, xpath);
        }
    }

    private String parse(InputStream stream) throws CoherenceException {
        assert (stream != null);
        Document doc = DomUtil.doc((InputStream)stream);
        Element root = doc.getDocumentElement();
        if (root == null) {
            throw new CoherenceException("Invalid coherence operational configuration: ");
        }
        String override = root.getAttribute(ATTR_OVERRIDE);
        this.parse(root, null);
        return override;
    }

    private String parse(File file) throws CoherenceException {
        assert (file != null && file.exists());
        Element root = DomUtil.root((File)file);
        if (root == null) {
            throw new CoherenceException("Invalid coherence operational configuration: " + file);
        }
        String override = root.getAttribute(ATTR_OVERRIDE);
        this.parse(root, null);
        return override;
    }

    private void parse(Element parent, String parentName) {
        for (Element element : DomUtil.elements((Element)parent)) {
            String xpath = DomUtil.basename((String)element.getNodeName());
            if (parentName != null) {
                StringBuffer buf = new StringBuffer(parentName);
                buf.append("/");
                buf.append(xpath);
                String id = element.getAttribute(ID);
                if (id != null && id.length() > 0) {
                    buf.append("(");
                    buf.append(id);
                    buf.append(")");
                }
                xpath = buf.toString();
            }
            String systemProperty = element.getAttribute(SYSTEM_PROPERTY);
            String value = DomUtil.text((Node)element);
            value = value == null ? null : value.trim();
            this.addSystemProperty(xpath, systemProperty, value);
            this.parse(element, xpath);
        }
    }

    private void addSystemProperty(String xpath, String systemProperty, String value) {
        SystemPropertyModel prop = this.getSystemPropertyModelFromXpath(xpath);
        if (prop != null) {
            prop.setSystemProperty(systemProperty);
            prop.setDefaultValue(value);
            return;
        }
        SystemPropertyModel model = new SystemPropertyModel(xpath, systemProperty, value);
        this.overrideList.add(model);
    }

    private SystemPropertyModel getSystemPropertyModelFromXpath(String xpath) {
        if (xpath != null) {
            for (SystemPropertyModel prop : this.overrideList) {
                if (!ObjectUtil.equal((Object)xpath, (Object)prop.getXpath())) continue;
                return prop;
            }
        }
        return null;
    }

    private SystemPropertyModel getSystemPropertyModelFromSystemProperty(String systemProperty) {
        if (systemProperty != null) {
            for (SystemPropertyModel prop : this.overrideList) {
                if (!ObjectUtil.equal((Object)systemProperty, (Object)prop.getSystemProperty())) continue;
                return prop;
            }
        }
        return null;
    }

    public synchronized boolean attach(Listener listener) {
        return this.listeners.attach(listener);
    }

    public synchronized boolean detach(Listener listener) {
        return this.listeners.detach(listener);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (SystemPropertyModel prop : this.overrideList) {
            buf.append(prop.getSystemProperty());
            buf.append(", ");
            buf.append(prop.getDefaultValue());
            buf.append(", ");
            buf.append(prop.getXpath());
            buf.append("\n");
        }
        return buf.toString();
    }

    public final class ModelChangedEvent
    extends Event {
        private ModelChangedEvent() {
        }
    }
}

