/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

import java.util.SortedSet;
import javax.xml.namespace.QName;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.TextChildXmlResource;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.VersionCompatibilityService;
import org.eclipse.sapphire.modeling.LayeredElementBindingImpl;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.w3c.dom.Node;

public class TextAndElementBinding
extends LayeredElementBindingImpl {
    @Text(value="failure = {0}.{1} : {2}")
    private static LocalizableText failure;
    @Text(value="Element name must be specified in @XmlElementBinding.Mapping annotation.")
    private static LocalizableText mustSpecifyElementNameMsg;
    private XmlPath parent_path;
    private QName parent_qname;
    private QName[] xmlElementNames;
    private ElementType[] ElementTypes;

    static {
        LocalizableText.init(TextAndElementBinding.class);
    }

    public void init(Property property) {
        super.init(property);
        this.initBindingMetadata();
    }

    private void initBindingMetadata() {
        Property property = this.property();
        try {
            XmlElementBinding xmlElementBindingAnnotation = (XmlElementBinding)property.definition().getAnnotation(XmlElementBinding.class);
            XmlNamespaceResolver xmlNamespaceResolver = ((XmlResource)property.element().resource()).getXmlNamespaceResolver();
            PossibleTypesService possibleTypesService = (PossibleTypesService)property.service(PossibleTypesService.class);
            SortedSet possible = possibleTypesService.types();
            this.ElementTypes = possible.toArray(new ElementType[possible.size()]);
            if (xmlElementBindingAnnotation.path().length() > 0) {
                String path = xmlElementBindingAnnotation.path();
                this.parent_path = new XmlPath(path, xmlNamespaceResolver);
                int slashIndex = path.lastIndexOf(47);
                if (slashIndex == -1) {
                    this.parent_qname = XmlUtil.createQualifiedName((String)path, (XmlNamespaceResolver)xmlNamespaceResolver);
                } else if (slashIndex > 0 && slashIndex < path.length() - 1) {
                    this.parent_qname = XmlUtil.createQualifiedName((String)path.substring(slashIndex + 1), (XmlNamespaceResolver)xmlNamespaceResolver);
                }
            }
            XmlElementBinding.Mapping[] mappings = xmlElementBindingAnnotation.mappings();
            this.xmlElementNames = new QName[this.ElementTypes.length];
            int i = 0;
            while (i < this.ElementTypes.length) {
                ElementType type = this.ElementTypes[i];
                XmlElementBinding.Mapping[] mappingArray = mappings;
                int n = mappings.length;
                int n2 = 0;
                while (n2 < n) {
                    XmlElementBinding.Mapping mapping = mappingArray[n2];
                    if (mapping.type() == type.getModelElementClass()) {
                        String mappingElementName = mapping.element().trim();
                        if (mappingElementName.length() == 0) {
                            throw new RuntimeException(mustSpecifyElementNameMsg.text());
                        }
                        if (mappingElementName.startsWith("$$")) {
                            this.xmlElementNames[i] = new QName(null, mappingElementName, "");
                            break;
                        }
                        this.xmlElementNames[i] = XmlUtil.createQualifiedName((String)mappingElementName, (XmlNamespaceResolver)xmlNamespaceResolver);
                        break;
                    }
                    ++n2;
                }
                if (this.xmlElementNames[i] == null) {
                    this.xmlElementNames[i] = this.createDefaultElementName(type, xmlNamespaceResolver);
                }
                ++i;
            }
        }
        catch (Exception e) {
            String msg = failure.format(new Object[]{property.element().type().getSimpleName(), property.name(), e.getMessage()});
            throw new RuntimeException(msg, e);
        }
    }

    protected XmlElement base(boolean createIfNecessary) {
        XmlResource resource = (XmlResource)this.property().element().resource();
        return resource.getXmlElement(createIfNecessary);
    }

    protected XmlElement parent(boolean createIfNecessary) {
        XmlElement parent = this.base(createIfNecessary);
        if (parent != null && this.parent_path != null) {
            parent = (XmlElement)parent.getChildNode(this.parent_path, createIfNecessary);
        }
        return parent;
    }

    protected QName createDefaultElementName(ElementType type, XmlNamespaceResolver xmlNamespaceResolver) {
        return XmlUtil.createDefaultElementName((ElementType)type);
    }

    private boolean elementEnabled() {
        VersionCompatibilityService vcService = (VersionCompatibilityService)this.property().service(VersionCompatibilityService.class);
        return vcService != null ? vcService.compatible() : true;
    }

    protected Object readUnderlyingObject() {
        XmlElement parent = this.parent(false);
        if (parent != null) {
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
                if (!XmlUtil.contains((QName[])this.xmlElementNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
                return element;
            }
            if (this.elementEnabled()) {
                QName[] qNameArray = this.xmlElementNames;
                int n = this.xmlElementNames.length;
                int n2 = 0;
                while (n2 < n) {
                    QName xmlElementName = qNameArray[n2];
                    String name = xmlElementName.getLocalPart();
                    if (name.startsWith("$$")) {
                        if (name.endsWith("ANY")) {
                            return parent;
                        }
                        String text = name.substring(2);
                        if (text.equalsIgnoreCase(parent.getText().trim())) {
                            return name;
                        }
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    protected Object createUnderlyingObject(ElementType type) {
        XmlElement parent;
        XmlElement base = this.base(false);
        if (base != null && (parent = this.parent(false)) != null) {
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
                if (!XmlUtil.contains((QName[])this.xmlElementNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
                element.remove();
            }
            parent.setText(null);
        }
        parent = this.parent(true);
        QName xmlElementName = this.xmlElementNames[MiscUtil.indexOf((Object[])this.ElementTypes, (Object)type)];
        String name = xmlElementName.getLocalPart();
        if (name.startsWith("$$")) {
            if (name.endsWith("ANY")) {
                return parent;
            }
            String text = name.substring(2);
            parent.setText(text);
            return name;
        }
        if (xmlElementName.getNamespaceURI().equals("")) {
            xmlElementName = new QName(parent.getNamespace(), xmlElementName.getLocalPart());
        }
        return parent.getChildElement(xmlElementName, true);
    }

    protected Resource createResource(Object obj) {
        boolean isXmlElement;
        XmlElement xmlElement;
        if (obj instanceof XmlElement) {
            xmlElement = (XmlElement)obj;
            isXmlElement = true;
        } else {
            xmlElement = this.parent(false);
            isXmlElement = false;
        }
        XmlResource parentXmlResource = (XmlResource)this.property().element().resource();
        if (isXmlElement) {
            return new ChildXmlResource((Resource)parentXmlResource, xmlElement);
        }
        return new TextChildXmlResource(parentXmlResource, xmlElement);
    }

    public ElementType type(Resource resource) {
        XmlElement xmlElement = ((XmlResource)resource).getXmlElement();
        QName xmlElementName = XmlUtil.createQualifiedName((Node)xmlElement.getDomNode());
        String xmlElementNamespace = xmlElementName.getNamespaceURI();
        int i = 0;
        while (i < this.xmlElementNames.length) {
            String name;
            if (XmlUtil.equal((QName)this.parent_qname, (QName)xmlElementName, (String)xmlElementNamespace) && (name = this.xmlElementNames[i].getLocalPart()).startsWith("$$")) {
                if (name.endsWith("ANY")) {
                    return this.ElementTypes[i];
                }
                String text = name.substring(2);
                if (text.equalsIgnoreCase(xmlElement.getText().trim())) {
                    return this.ElementTypes[i];
                }
            }
            if (XmlUtil.equal((QName)this.xmlElementNames[i], (QName)xmlElementName, (String)xmlElementNamespace)) {
                return this.ElementTypes[i];
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    public void remove() {
        XmlElement parent;
        XmlElement base = this.base(false);
        if (base != null && (parent = this.parent(false)) != null) {
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
                if (!XmlUtil.contains((QName[])this.xmlElementNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
                element.remove();
            }
            parent.setText(null);
            if (parent != base) {
                base.removeChildNode(this.parent_path);
            }
        }
    }
}

