/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.SizeKMUnit;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberWithUnit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class SizeValidator
extends ValidationService {
    private String unitProp;
    private String min;
    private BigDecimal minByte;
    private String max;
    private BigDecimal maxByte;

    protected void initValidationService() {
        NumberWithUnit nu;
        this.unitProp = this.param("unitProp");
        this.min = this.param("min");
        if (this.min != null && this.min.length() > 0) {
            nu = NumberWithUnit.parse(this.min);
            this.minByte = this.getSizeInBytes(nu.getNumber(), nu.getUnit());
        }
        this.max = this.param("max");
        if (this.max != null && this.max.length() > 0) {
            nu = NumberWithUnit.parse(this.max);
            this.maxByte = this.getSizeInBytes(nu.getNumber(), nu.getUnit());
        }
    }

    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        String text = value.text();
        if (text != null) {
            try {
                BigDecimal digit = new BigDecimal(text);
                if (!BigDecimal.ZERO.equals(digit)) {
                    Element element = value.element();
                    if (this.unitProp != null) {
                        Object unit = ((Value)element.property(this.unitProp)).content();
                        BigDecimal time = null;
                        if (unit instanceof SizeUnit) {
                            time = this.getSizeInBytes(digit, (SizeUnit)((Object)unit));
                        } else if (unit instanceof SizeKMUnit) {
                            time = this.getSizeInBytes(digit, (SizeKMUnit)((Object)unit));
                        }
                        if (time != null && this.min != null && this.min.length() > 0 && this.minByte != null && time.compareTo(this.minByte) < 0) {
                            NumberWithUnit nu = new NumberWithUnit(digit.toString(), unit.toString());
                            return Status.createErrorStatus((String)Resources.bind((String)Resources.too_small, (Object)nu, (Object)this.min));
                        }
                        if (time != null && this.max != null && this.max.length() > 0 && this.maxByte != null && time.compareTo(this.maxByte) > 0) {
                            NumberWithUnit nu = new NumberWithUnit(digit.toString(), unit.toString());
                            return Status.createErrorStatus((String)Resources.bind((String)Resources.too_big, (Object)nu, (Object)this.max));
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return Status.createOkStatus();
    }

    private BigDecimal getSizeInBytes(String digit, String unit) {
        return this.getSizeInBytes(new BigDecimal(digit), SizeUnit.valueOf(unit == null ? "KB" : unit));
    }

    private BigDecimal getSizeInBytes(BigDecimal digit, SizeKMUnit unit) {
        switch (unit) {
            case KB: {
                return digit.multiply(new BigDecimal(1000));
            }
            case MB: {
                return digit.multiply(new BigDecimal(1000000));
            }
        }
        return digit;
    }

    private BigDecimal getSizeInBytes(BigDecimal digit, SizeUnit unit) {
        switch (unit) {
            case KB: {
                return digit.multiply(new BigDecimal(1000));
            }
            case MB: {
                return digit.multiply(new BigDecimal(1000000));
            }
            case GB: {
                return digit.multiply(new BigDecimal(1000000000));
            }
            case TB: {
                return digit.multiply(new BigDecimal("1000000000000"));
            }
        }
        return digit;
    }

    private static final class Resources
    extends NLS {
        public static String too_small;
        public static String too_big;

        static {
            Resources.initializeMessages((String)SizeValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

