/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

import java.math.BigDecimal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ParamValueValidator
extends ValidationService {
    private String paramTypeName;
    private FilteredListener<PropertyContentEvent> listener;

    protected void initValidationService() {
        super.initValidationService();
        this.paramTypeName = this.param("property");
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ParamValueValidator.this.refresh();
            }
        };
        Element element = (Element)this.context(Element.class);
        element.attach(this.listener, this.paramTypeName);
    }

    public void dispose() {
        super.dispose();
        Element element = (Element)this.context(Element.class);
        element.detach(this.listener, this.paramTypeName);
    }

    protected Status compute() {
        Element element;
        String paramType;
        Value value = (Value)this.context(Value.of(String.class));
        String paramValue = (String)value.content();
        if (paramValue != null && paramValue.length() > 0 && (paramType = ((Value)(element = value.element()).property(this.paramTypeName)).text()) != null && paramType.length() > 0) {
            if (paramType.equalsIgnoreCase("int") || paramType.equals("java.lang.Integer")) {
                try {
                    Integer.parseInt(paramValue);
                }
                catch (NumberFormatException numberFormatException) {
                    return Status.createErrorStatus((String)Resources.bind((String)Resources.integerError, (Object)paramValue));
                }
            }
            if (paramType.equalsIgnoreCase("long") || paramType.equals("java.lang.Long")) {
                try {
                    Long.parseLong(paramValue);
                }
                catch (NumberFormatException numberFormatException) {
                    return Status.createErrorStatus((String)Resources.bind((String)Resources.longError, (Object)paramValue));
                }
            }
            if (paramType.equalsIgnoreCase("boolean") || paramType.equals("java.lang.Boolean")) {
                try {
                    if (!paramValue.equalsIgnoreCase(Boolean.TRUE.toString()) && !paramValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
                        return Status.createErrorStatus((String)Resources.bind((String)Resources.booleanError, (Object)paramValue));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return Status.createErrorStatus((String)Resources.bind((String)Resources.booleanError, (Object)paramValue));
                }
            }
            if (paramType.equalsIgnoreCase("double") || paramType.equals("java.lang.Double")) {
                try {
                    Double.parseDouble(paramValue);
                }
                catch (NumberFormatException numberFormatException) {
                    return Status.createErrorStatus((String)Resources.bind((String)Resources.doubleError, (Object)paramValue));
                }
            }
            if (paramType.equalsIgnoreCase("float") || paramType.equals("java.lang.Float")) {
                try {
                    Float.parseFloat(paramValue);
                }
                catch (NumberFormatException numberFormatException) {
                    return Status.createErrorStatus((String)Resources.bind((String)Resources.floatError, (Object)paramValue));
                }
            }
            if (paramType.equalsIgnoreCase("decimal") || paramType.equals("java.math.BigDecimal")) {
                try {
                    new BigDecimal(paramValue);
                }
                catch (NumberFormatException numberFormatException) {
                    return Status.createErrorStatus((String)Resources.bind((String)Resources.decimalError, (Object)paramValue));
                }
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String integerError;
        public static String longError;
        public static String booleanError;
        public static String doubleError;
        public static String floatError;
        public static String decimalError;

        static {
            Resources.initializeMessages((String)ParamValueValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

