/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

import java.math.BigDecimal;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.EnablementServiceData;

public class NumberUnitEnabler
extends EnablementService {
    private String numberPropName;

    protected void initEnablementService() {
        this.numberPropName = this.param("property");
        ((Element)this.context(Element.class)).property(this.numberPropName).attach((Listener)new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                NumberUnitEnabler.this.refresh();
            }
        });
    }

    protected EnablementServiceData compute() {
        ElementType type;
        ValueProperty numberProp;
        Element element = (Element)this.context(Element.class);
        Value numberValue = element.property(numberProp = (ValueProperty)(type = element.type()).property(this.numberPropName));
        if (numberValue.text(false) == null) {
            return new EnablementServiceData(false);
        }
        if (numberProp.isOfType(Long.class)) {
            long number = 0L;
            try {
                number = Long.parseLong(numberValue.text(false));
            }
            catch (NumberFormatException numberFormatException) {
                return new EnablementServiceData(false);
            }
            return new EnablementServiceData(number > 0L);
        }
        if (numberProp.isOfType(Integer.class)) {
            int number = 0;
            try {
                number = Integer.parseInt(numberValue.text(false));
            }
            catch (NumberFormatException numberFormatException) {
                return new EnablementServiceData(false);
            }
            return new EnablementServiceData(number > 0);
        }
        if (numberProp.isOfType(BigDecimal.class)) {
            BigDecimal number = BigDecimal.ZERO;
            try {
                number = new BigDecimal(numberValue.text(false));
            }
            catch (NumberFormatException numberFormatException) {
                return new EnablementServiceData(false);
            }
            return new EnablementServiceData(number.compareTo(BigDecimal.ZERO) > 0);
        }
        return new EnablementServiceData(false);
    }
}

