/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

import java.util.Map;
import oracle.eclipse.tools.coherence.internal.CoherencePlugin;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CoherenceVersionUtil {
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";

    public static void changeNamespace(Document document, String elementName, String oldNamespace, String newNamespace, String newSchemaLocation, String newSystemId) {
        Element oldRootElement = document.getDocumentElement();
        if (oldRootElement != null) {
            DocumentType doctype;
            String newNameSpace = null;
            Element newRootElement = document.createElementNS(newNamespace, elementName);
            if (newSystemId != null) {
                if (document.getDoctype() == null) {
                    doctype = document.getImplementation().createDocumentType(elementName, null, newSystemId);
                    Text newline = document.createTextNode(System.getProperty("line.separator"));
                    document.insertBefore(doctype, oldRootElement);
                    document.insertBefore(newline, oldRootElement);
                }
            } else if (newSchemaLocation != null) {
                doctype = document.getDoctype();
                if (doctype != null) {
                    NodeList dnodes = document.getChildNodes();
                    int i = 0;
                    while (i < dnodes.getLength()) {
                        Node dnode = dnodes.item(i);
                        if (dnode.getNodeType() == 10) {
                            document.removeChild(dnode);
                            break;
                        }
                        ++i;
                    }
                }
                newRootElement.setAttribute(XMLNS, newNamespace);
                newRootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                newNameSpace = CoherenceVersionUtil.getNamespace(newSchemaLocation);
                if (newNameSpace != null) {
                    newRootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", newNameSpace);
                }
            }
            NodeList children = oldRootElement.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                Node oldChildNode = children.item(i);
                Node newChildNode = CoherenceVersionUtil.changeNamespace(oldChildNode, oldNamespace, newNamespace, newSchemaLocation);
                newRootElement.appendChild(newChildNode);
                ++i;
            }
            Node nodeAfterRootElement = oldRootElement.getNextSibling();
            document.removeChild(oldRootElement);
            document.insertBefore(newRootElement, nodeAfterRootElement);
        }
    }

    private static String getNamespace(String schemaLocation) {
        try {
            XmlDocumentSchema xmlDocumentSchema = XmlDocumentSchemasCache.getSchema((String)schemaLocation);
            if (xmlDocumentSchema != null) {
                StringBuilder buf = new StringBuilder();
                for (Map.Entry entry : xmlDocumentSchema.getSchemaLocations().entrySet()) {
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append((String)entry.getKey());
                    buf.append(' ');
                    buf.append((String)entry.getValue());
                }
                return buf.toString();
            }
        }
        catch (Exception e) {
            CoherencePlugin.log(e);
        }
        return null;
    }

    private static Node changeNamespace(Node node, String oldNamespace, String newNamespace, String newSchemaLocation) {
        if (node instanceof Element) {
            String elementNameSpaceUri = node.getNamespaceURI();
            String elementQualifiedName = node.getNodeName();
            String nameSpaceDeclarationAttr = null;
            if (elementNameSpaceUri != null && elementNameSpaceUri.equals(oldNamespace)) {
                elementNameSpaceUri = newNamespace;
                String prefix = node.getPrefix();
                nameSpaceDeclarationAttr = prefix == null ? XMLNS : XMLNS_COLON + prefix;
            }
            Document document = node.getOwnerDocument();
            Element newElement = document.createElementNS(elementNameSpaceUri, elementQualifiedName);
            NodeList children = node.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                Node oldChildNode = children.item(i);
                Node newChildNode = CoherenceVersionUtil.changeNamespace(oldChildNode, oldNamespace, newNamespace, newSchemaLocation);
                newElement.appendChild(newChildNode);
                ++i;
            }
            NamedNodeMap attributes = node.getAttributes();
            boolean updatedNamespace = false;
            boolean updatedSchemaLocation = false;
            int i2 = 0;
            int n2 = attributes.getLength();
            while (i2 < n2) {
                Attr attr = (Attr)attributes.item(i2);
                String attrNameSpaceUri = attr.getNamespaceURI();
                String attrQualifiedName = attr.getNodeName();
                String attrValue = attr.getValue();
                if (attrQualifiedName.equals(nameSpaceDeclarationAttr)) {
                    attrValue = newNamespace;
                    updatedNamespace = true;
                } else if (attr.getLocalName() != null && attr.getLocalName().equals("schemaLocation")) {
                    attrValue = CoherenceVersionUtil.createSchemaLocationAttrValue(newSchemaLocation);
                    updatedSchemaLocation = true;
                }
                newElement.setAttributeNS(attrNameSpaceUri, attrQualifiedName, attrValue);
                ++i2;
            }
            if (updatedNamespace && !updatedSchemaLocation) {
                CoherenceVersionUtil.configSchemaLocation(newElement, newSchemaLocation);
            }
            return newElement;
        }
        return node.cloneNode(true);
    }

    public static void configSchemaLocation(Element element, String primarySchemaLocation) {
        String schemaLocationAttrValue = CoherenceVersionUtil.createSchemaLocationAttrValue(primarySchemaLocation);
        element.setAttributeNS(null, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", schemaLocationAttrValue);
    }

    private static String createSchemaLocationAttrValue(String primarySchemaLocation) {
        XmlDocumentSchema xmlDocumentSchema = XmlDocumentSchemasCache.getSchema((String)primarySchemaLocation);
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : xmlDocumentSchema.getSchemaLocations().entrySet()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append((String)entry.getKey());
            buf.append(' ');
            buf.append((String)entry.getValue());
        }
        return buf.toString();
    }
}

