/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.internal;

import java.util.SortedSet;
import javax.xml.namespace.QName;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.TextChildXmlResource;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.LayeredElementBindingImpl;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlMetaComment;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.w3c.dom.Node;

public class AddressProviderElementBinding
extends LayeredElementBindingImpl {
    private static final QName[] EMPTY_QNAME = new QName[0];
    private static final String ADDRESS_PROVIDER = "address-provider";
    @Text(value="failure = {0}.{1} : {2}")
    private static LocalizableText failure;
    private XmlPath parentPath;
    private XmlPath addressProviderPath;
    private static final String SOCKET_ADDRESSES = "socket-addresses";
    private static final String INSTANCE = "instance";
    private static final String ADDRESS_PROVIDER_INSTANCE = "address-provider-instance";
    private static final String ADDRESS_PROVIDER_NAME = "address-provider-name";
    private ElementType instanceType;
    private QName[] instanceNames = EMPTY_QNAME;
    private ElementType socketAddressesType;
    private QName socketAddressesQName;
    private ElementType addressProviderInstanceType;
    private ElementType addressProviderNameType;
    private ElementType[] modelElementTypes;
    private QName[] xmlElementNames = EMPTY_QNAME;

    static {
        LocalizableText.init(AddressProviderElementBinding.class);
    }

    public void init(Property property) {
        super.init(property);
        this.initBindingMetadata();
    }

    private void initBindingMetadata() {
        Property property = this.property();
        try {
            XmlElementBinding xmlElementBindingAnnotation = (XmlElementBinding)property.definition().getAnnotation(XmlElementBinding.class);
            XmlNamespaceResolver xmlNamespaceResolver = ((XmlResource)property.element().resource()).getXmlNamespaceResolver();
            PossibleTypesService possibleTypesService = (PossibleTypesService)property.service(PossibleTypesService.class);
            SortedSet possible = possibleTypesService.types();
            ElementType[] modelElementTypes = possible.toArray(new ElementType[possible.size()]);
            if (xmlElementBindingAnnotation.path().length() > 0) {
                String path = xmlElementBindingAnnotation.path();
                this.parentPath = new XmlPath(path, xmlNamespaceResolver);
            }
            XmlElementBinding.Mapping[] mappings = xmlElementBindingAnnotation.mappings();
            int i = 0;
            while (i < modelElementTypes.length) {
                ElementType type = modelElementTypes[i];
                XmlElementBinding.Mapping[] mappingArray = mappings;
                int n = mappings.length;
                int n2 = 0;
                while (n2 < n) {
                    XmlElementBinding.Mapping mapping = mappingArray[n2];
                    if (mapping.type() == type.getModelElementClass()) {
                        String mappingElementName = mapping.element().trim();
                        if ("$$instance".equals(mappingElementName) || "$$address-provider-instance".equals(mappingElementName)) {
                            if ("$$instance".equals(mappingElementName)) {
                                this.instanceType = type;
                            } else {
                                this.addressProviderInstanceType = type;
                                this.addressProviderPath = new XmlPath(ADDRESS_PROVIDER, xmlNamespaceResolver);
                            }
                            this.instanceNames = new QName[4];
                            this.instanceNames[0] = XmlUtil.createQualifiedName((String)"class-name", (XmlNamespaceResolver)xmlNamespaceResolver);
                            this.instanceNames[1] = XmlUtil.createQualifiedName((String)"class-factory-name", (XmlNamespaceResolver)xmlNamespaceResolver);
                            this.instanceNames[2] = XmlUtil.createQualifiedName((String)"method-name", (XmlNamespaceResolver)xmlNamespaceResolver);
                            this.instanceNames[3] = XmlUtil.createQualifiedName((String)"init-params", (XmlNamespaceResolver)xmlNamespaceResolver);
                        } else if ("$$socket-addresses".equals(mappingElementName)) {
                            this.socketAddressesType = type;
                            this.socketAddressesQName = XmlUtil.createQualifiedName((String)"socket-address", (XmlNamespaceResolver)xmlNamespaceResolver);
                        } else if ("$$address-provider-name".equals(mappingElementName)) {
                            this.addressProviderNameType = type;
                            this.addressProviderPath = new XmlPath(ADDRESS_PROVIDER, xmlNamespaceResolver);
                        } else {
                            this.modelElementTypes = new ElementType[1];
                            this.modelElementTypes[0] = type;
                            this.xmlElementNames = new QName[1];
                            this.xmlElementNames[0] = XmlUtil.createQualifiedName((String)mappingElementName, (XmlNamespaceResolver)xmlNamespaceResolver);
                        }
                    }
                    ++n2;
                }
                ++i;
            }
        }
        catch (Exception e) {
            String msg = failure.format(new Object[]{property.element().type().getSimpleName(), property.name(), e.getMessage()});
            throw new RuntimeException(msg, e);
        }
    }

    protected XmlElement base(boolean createIfNecessary) {
        XmlResource resource = (XmlResource)this.property().element().resource();
        return resource.getXmlElement(createIfNecessary);
    }

    protected XmlElement parent(boolean createIfNecessary) {
        XmlElement parent = this.base(createIfNecessary);
        if (parent != null && this.parentPath != null) {
            parent = (XmlElement)parent.getChildNode(this.parentPath, createIfNecessary);
        }
        return parent;
    }

    private XmlElement getAddressProvider(boolean createIfNecessary) {
        if (this.addressProviderPath != null) {
            XmlElement addressProvider = this.parent(createIfNecessary);
            if (addressProvider != null) {
                addressProvider = (XmlElement)addressProvider.getChildNode(this.addressProviderPath, createIfNecessary);
            }
            return addressProvider;
        }
        return null;
    }

    protected QName createDefaultElementName(ElementType type, XmlNamespaceResolver xmlNamespaceResolver) {
        return XmlUtil.createDefaultElementName((ElementType)type);
    }

    protected Object readUnderlyingObject() {
        XmlElement parent = this.parent(false);
        if (parent != null) {
            String comment = parent.getMetaCommentText(parent.getLocalName());
            if (INSTANCE.equals(comment)) {
                return INSTANCE;
            }
            if (SOCKET_ADDRESSES.equals(comment)) {
                return SOCKET_ADDRESSES;
            }
            if (ADDRESS_PROVIDER_NAME.equals(comment)) {
                return ADDRESS_PROVIDER_NAME;
            }
            if (ADDRESS_PROVIDER_INSTANCE.equals(comment)) {
                return ADDRESS_PROVIDER_INSTANCE;
            }
            XmlElement addressProvider = this.getAddressProvider(false);
            if (addressProvider != null) {
                for (XmlElement element : addressProvider.getChildElements()) {
                    QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
                    if (!XmlUtil.contains((QName[])this.instanceNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
                    return ADDRESS_PROVIDER_INSTANCE;
                }
                return ADDRESS_PROVIDER_NAME;
            }
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
                if (XmlUtil.contains((QName[])this.instanceNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) {
                    return INSTANCE;
                }
                if (this.socketAddressesQName != null && XmlUtil.equal((QName)this.socketAddressesQName, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) {
                    return SOCKET_ADDRESSES;
                }
                if (!XmlUtil.contains((QName[])this.xmlElementNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
                return element;
            }
        }
        return null;
    }

    protected Object createUnderlyingObject(ElementType type) {
        XmlElement parent;
        XmlElement base = this.base(false);
        if (base != null && (parent = this.parent(false)) != null) {
            XmlElement addressProvider;
            XmlMetaComment comment = parent.getMetaComment(parent.getLocalName(), false);
            if (comment != null) {
                comment.remove();
            }
            if ((addressProvider = this.getAddressProvider(false)) != null) {
                addressProvider.remove();
            }
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
                if (XmlUtil.contains((QName[])this.instanceNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) {
                    element.remove();
                }
                if (this.socketAddressesQName != null && XmlUtil.equal((QName)this.socketAddressesQName, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) {
                    element.remove();
                }
                if (!XmlUtil.contains((QName[])this.xmlElementNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
                element.remove();
            }
        }
        parent = this.parent(true);
        if (type.equals(this.instanceType)) {
            parent.setMetaCommentText(parent.getLocalName(), INSTANCE);
            return INSTANCE;
        }
        if (type.equals(this.socketAddressesType)) {
            parent.setMetaCommentText(parent.getLocalName(), SOCKET_ADDRESSES);
            return SOCKET_ADDRESSES;
        }
        if (type.equals(this.addressProviderNameType)) {
            parent.setMetaCommentText(parent.getLocalName(), ADDRESS_PROVIDER_NAME);
            this.getAddressProvider(true);
            return ADDRESS_PROVIDER_NAME;
        }
        if (type.equals(this.addressProviderInstanceType)) {
            parent.setMetaCommentText(parent.getLocalName(), ADDRESS_PROVIDER_INSTANCE);
            this.getAddressProvider(true);
            return ADDRESS_PROVIDER_INSTANCE;
        }
        QName xmlElementName = this.xmlElementNames[MiscUtil.indexOf((Object[])this.modelElementTypes, (Object)type)];
        return parent.getChildElement(xmlElementName, true);
    }

    protected Resource createResource(Object obj) {
        boolean isXmlElement;
        XmlElement xmlElement;
        if (obj instanceof XmlElement) {
            xmlElement = (XmlElement)obj;
            isXmlElement = true;
        } else {
            xmlElement = obj.equals(ADDRESS_PROVIDER_INSTANCE) || obj.equals(ADDRESS_PROVIDER_NAME) ? this.getAddressProvider(false) : this.parent(false);
            isXmlElement = false;
        }
        XmlResource parentXmlResource = (XmlResource)this.property().element().resource();
        if (isXmlElement) {
            return new ChildXmlResource((Resource)parentXmlResource, xmlElement);
        }
        return new TextChildXmlResource(parentXmlResource, xmlElement);
    }

    public ElementType type(Resource resource) {
        XmlElement xmlElement = ((XmlResource)resource).getXmlElement();
        QName xmlElementName = XmlUtil.createQualifiedName((Node)xmlElement.getDomNode());
        String text = xmlElement.getMetaCommentText(xmlElement.getLocalName());
        if (text == null) {
            XmlElement parentElement = xmlElement.getParent();
            text = parentElement.getMetaCommentText(parentElement.getLocalName());
        }
        if (INSTANCE.equals(text)) {
            return this.instanceType;
        }
        if (SOCKET_ADDRESSES.equals(text)) {
            return this.socketAddressesType;
        }
        if (ADDRESS_PROVIDER_NAME.equals(text)) {
            return this.addressProviderNameType;
        }
        if (ADDRESS_PROVIDER_INSTANCE.equals(text)) {
            return this.addressProviderInstanceType;
        }
        XmlElement addressProvider = this.getAddressProvider(false);
        if (addressProvider != null) {
            for (XmlElement element : addressProvider.getChildElements()) {
                QName childXmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
                if (!XmlUtil.contains((QName[])this.instanceNames, (QName)childXmlElementName, (String)childXmlElementName.getNamespaceURI())) continue;
                return this.addressProviderInstanceType;
            }
            return this.addressProviderNameType;
        }
        if (this.xmlElementNames.length > 0 && XmlUtil.equal((QName)this.xmlElementNames[0], (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) {
            return this.modelElementTypes[0];
        }
        for (XmlElement element : xmlElement.getChildElements()) {
            QName childXmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
            if (XmlUtil.contains((QName[])this.instanceNames, (QName)childXmlElementName, (String)childXmlElementName.getNamespaceURI())) {
                return this.instanceType;
            }
            if (this.socketAddressesQName == null || !XmlUtil.equal((QName)this.socketAddressesQName, (QName)childXmlElementName, (String)childXmlElementName.getNamespaceURI())) continue;
            return this.socketAddressesType;
        }
        throw new IllegalStateException();
    }

    public void remove() {
        XmlElement parent;
        XmlElement base = this.base(false);
        if (base != null && (parent = this.parent(false)) != null) {
            XmlElement addressProvider;
            XmlMetaComment comment = parent.getMetaComment(parent.getLocalName(), false);
            if (comment != null) {
                comment.remove();
            }
            if ((addressProvider = this.getAddressProvider(false)) != null) {
                addressProvider.remove();
            }
            for (XmlElement element : parent.getChildElements()) {
                QName xmlElementName = XmlUtil.createQualifiedName((Node)element.getDomNode());
                if (XmlUtil.contains((QName[])this.instanceNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) {
                    element.remove();
                }
                if (this.socketAddressesQName != null && XmlUtil.equal((QName)this.socketAddressesQName, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) {
                    element.remove();
                }
                if (!XmlUtil.contains((QName[])this.xmlElementNames, (QName)xmlElementName, (String)xmlElementName.getNamespaceURI())) continue;
                element.remove();
            }
            if (parent != base && parent.isEmpty()) {
                base.removeChildNode(this.parentPath);
            }
        }
    }
}

