/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal;

import java.util.Set;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICoherenceCacheConfig;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IExternalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IFlashjournalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ILocalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IOverflowScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IPagedExternalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IRamjournalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IReadWriteBackingMapScheme;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.services.PossibleValuesService;

public class SchemeRefValuesProvider
extends PossibleValuesService {
    private Listener listener;

    protected void init() {
        super.init();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SchemeRefValuesProvider.this.broadcast();
            }
        };
        ((ICoherenceCacheConfig)this.context(ICoherenceCacheConfig.class)).attach(this.listener, "/CachingSchemes/SchemeName");
    }

    public void dispose() {
        super.dispose();
        ((ICoherenceCacheConfig)this.context(ICoherenceCacheConfig.class)).detach(this.listener, "/CachingSchemes/SchemeName");
    }

    protected void fillPossibleValues(Set<String> values) {
        Element element = (Element)this.context(Element.class);
        Element descriptor = element.root();
        if (descriptor instanceof ICoherenceCacheConfig) {
            ICoherenceCacheConfig config = (ICoherenceCacheConfig)descriptor;
            ICachingScheme self = (ICachingScheme)element.nearest(ICachingScheme.class);
            ElementType type = this.getElementType(self);
            for (ICachingScheme scheme : config.getCachingSchemes()) {
                String name = scheme.getSchemeName().text();
                if (name == null || name.length() <= 0) continue;
                if (self != null && type != null) {
                    if (name.equals(self.getSchemeName().text()) || !scheme.type().equals(type)) continue;
                    values.add(name);
                    continue;
                }
                values.add(name);
            }
        }
    }

    private ElementType getElementType(ICachingScheme scheme) {
        if (scheme != null) {
            IClassScheme classScheme = (IClassScheme)scheme.nearest(IClassScheme.class);
            if (classScheme != null) {
                return IClassScheme.TYPE;
            }
            IExternalScheme externalScheme = (IExternalScheme)scheme.nearest(IExternalScheme.class);
            if (externalScheme != null) {
                return IExternalScheme.TYPE;
            }
            IFlashjournalScheme flashjournalScheme = (IFlashjournalScheme)scheme.nearest(IFlashjournalScheme.class);
            if (flashjournalScheme != null) {
                return IFlashjournalScheme.TYPE;
            }
            ILocalScheme localScheme = (ILocalScheme)scheme.nearest(ILocalScheme.class);
            if (localScheme != null) {
                return ILocalScheme.TYPE;
            }
            IOverflowScheme overflowScheme = (IOverflowScheme)scheme.nearest(IOverflowScheme.class);
            if (overflowScheme != null) {
                return IOverflowScheme.TYPE;
            }
            IPagedExternalScheme pageExternalScheme = (IPagedExternalScheme)scheme.nearest(IPagedExternalScheme.class);
            if (pageExternalScheme != null) {
                return IPagedExternalScheme.TYPE;
            }
            IRamjournalScheme ramjournalScheme = (IRamjournalScheme)scheme.nearest(IRamjournalScheme.class);
            if (ramjournalScheme != null) {
                return IRamjournalScheme.TYPE;
            }
            IReadWriteBackingMapScheme readWriteBackingMapScheme = (IReadWriteBackingMapScheme)scheme.nearest(IReadWriteBackingMapScheme.class);
            if (readWriteBackingMapScheme != null) {
                return IReadWriteBackingMapScheme.TYPE;
            }
            return scheme.type();
        }
        return null;
    }
}

