/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal;

import oracle.eclipse.tools.coherence.descriptors.cacheConfig.CoherenceCacheConfigService;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICoherenceCacheConfig;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberWithUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;

public class SchemeRefDefaultValueProvider
extends DefaultValueService {
    private String path = null;
    private Option numberUnit = Option.NONE;
    private String dependsOn = null;
    private Listener listener;

    protected void initDefaultValueService() {
        ICoherenceCacheConfig config;
        this.path = this.param("path");
        String numberUnitStr = this.param("default");
        this.numberUnit = Option.NONE;
        if (numberUnitStr != null) {
            if ("ms".equals(numberUnitStr)) {
                this.numberUnit = Option.MS;
            } else if ("true".equalsIgnoreCase(numberUnitStr)) {
                this.numberUnit = Option.NUMBER;
            } else if ("false".equalsIgnoreCase(numberUnitStr)) {
                this.numberUnit = Option.UNIT;
            }
        }
        this.dependsOn = this.param("dependsOn");
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SchemeRefDefaultValueProvider.this.refresh();
            }
        };
        ICachingScheme scheme = (ICachingScheme)this.context(ICachingScheme.class);
        if (scheme != null) {
            scheme.getSchemeRef().attach(this.listener);
        }
        if (this.dependsOn != null && this.dependsOn.length() > 0 && (config = (ICoherenceCacheConfig)this.context(ICoherenceCacheConfig.class)) != null) {
            config.attach(this.listener, this.dependsOn);
        }
    }

    protected DefaultValueServiceData compute() {
        String defaultText;
        IProject project;
        Property obj;
        ICachingScheme scheme2;
        ICachingScheme scheme;
        String schemeRefName;
        Element element = (Element)this.context(Element.class);
        if (element instanceof ICachingScheme && (schemeRefName = (scheme = (ICachingScheme)element).getSchemeRef().text(false)) != null && schemeRefName.length() > 0 && (scheme2 = this.getCachingScheme(schemeRefName)) != null && (obj = scheme2.property((PropertyDef)this.context(PropertyDef.class))) instanceof Value) {
            String defaultValue = ((Value)obj).text();
            return new DefaultValueServiceData(defaultValue);
        }
        if (this.path != null && this.path.length() > 0 && (project = (IProject)element.adapt(IProject.class)) != null && (defaultText = CoherenceCacheConfigService.getTextValue(project, this.path)) != null) {
            if (this.numberUnit != Option.NONE) {
                NumberWithUnit nu = NumberWithUnit.parse(defaultText);
                if (this.numberUnit == Option.NUMBER) {
                    return new DefaultValueServiceData(nu.getNumber());
                }
                if (this.numberUnit == Option.UNIT) {
                    if (nu.getUnit() == null) {
                        return new DefaultValueServiceData(this.getDefaultValueAnnotation());
                    }
                    return new DefaultValueServiceData(nu.getUnit());
                }
                if (this.numberUnit == Option.MS) {
                    return new DefaultValueServiceData(this.getTimeInMs(nu));
                }
            }
            return new DefaultValueServiceData(defaultText);
        }
        return new DefaultValueServiceData(this.getDefaultValueAnnotation());
    }

    private String getTimeInMs(NumberWithUnit nu) {
        String unit = nu.getUnit();
        Long number = Long.parseLong(nu.getNumber());
        if ("s".equalsIgnoreCase(unit)) {
            number = number * 1000L;
        } else if ("m".equalsIgnoreCase(unit)) {
            number = number * 1000L * 60L;
        } else if ("h".equalsIgnoreCase(unit)) {
            number = number * 1000L * 60L * 60L;
        } else if ("d".equalsIgnoreCase(unit)) {
            number = number * 1000L * 60L * 60L * 24L;
        }
        return number.toString();
    }

    private String getDefaultValueAnnotation() {
        DefaultValue defaultValueAnnotation = (DefaultValue)((PropertyDef)this.context(PropertyDef.class)).getAnnotation(DefaultValue.class);
        return defaultValueAnnotation != null ? defaultValueAnnotation.text() : null;
    }

    private ICachingScheme getCachingScheme(String schemeRefName) {
        Element descriptor = ((Element)this.context(Element.class)).root();
        if (descriptor instanceof ICoherenceCacheConfig) {
            ICoherenceCacheConfig config = (ICoherenceCacheConfig)descriptor;
            for (ICachingScheme scheme : config.getCachingSchemes()) {
                if (!schemeRefName.equals(scheme.getSchemeName().text())) continue;
                return scheme;
            }
        }
        return null;
    }

    public void dispose() {
        ICoherenceCacheConfig config;
        ICachingScheme scheme = (ICachingScheme)this.context(ICachingScheme.class);
        if (scheme != null && !scheme.disposed()) {
            scheme.getSchemeRef().detach(this.listener);
        }
        if (this.dependsOn != null && this.dependsOn.length() > 0 && (config = (ICoherenceCacheConfig)this.context(ICoherenceCacheConfig.class)) != null && !config.disposed()) {
            config.detach(this.listener, this.dependsOn);
        }
        this.listener = null;
        super.dispose();
    }

    private static enum Option {
        NONE,
        NUMBER,
        UNIT,
        MS;

    }
}

