/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal;

import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public class ParamTypeCustomBinding
extends XmlValueBindingImpl {
    private String path;
    private boolean isParamTypeName = false;

    public void init(Property property) {
        super.init(property);
        String[] params = ((CustomXmlValueBinding)property.definition().getAnnotation(CustomXmlValueBinding.class)).params();
        if (params.length > 0) {
            this.path = params[0];
            if (params.length > 1) {
                this.isParamTypeName = params[1].equals("true");
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public boolean isParamTypeName() {
        return this.isParamTypeName;
    }

    public void setIsParamTypeName(boolean isParamTypeName) {
        this.isParamTypeName = isParamTypeName;
    }

    public XmlNode getXmlNode() {
        XmlElement el = this.xml(false);
        if (this.path != null && el != null) {
            XmlPath xmlPath = new XmlPath(this.path);
            return el.getChildNode(xmlPath, false);
        }
        return el;
    }

    public ParamType readParamType() {
        XmlNode child = this.getXmlNode();
        String value = child != null ? child.getText() : null;
        return ParamType.parse(value);
    }

    public void writeParamTypeName(String name) {
        ParamType paramType = this.readParamType();
        paramType.setName(name);
        this.writeParamType(paramType);
    }

    protected void writeParamType(ParamType paramType) {
        XmlElement el = this.xml(true);
        if (this.path != null) {
            XmlPath xmlPath = new XmlPath(this.path);
            if (paramType.getValue() == null || paramType.getValue().length() == 0) {
                el.removeChildNode(xmlPath);
            } else {
                el.setChildNodeText(xmlPath, paramType.toString(), true);
            }
        } else {
            el.setText(paramType.toString());
        }
    }

    public String read() {
        ParamType paramType = this.readParamType();
        if (this.isParamTypeName) {
            return paramType.getName();
        }
        return paramType.getValue();
    }

    public void write(String value) {
        ParamType paramType = this.readParamType();
        if (this.isParamTypeName) {
            paramType.setName(value);
        } else {
            paramType.setValue(value);
        }
        this.writeParamType(paramType);
    }
}

