/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal;

import java.util.Set;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.CoherenceCacheConfigService;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICoherenceCacheConfig;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.OverrideValuesProviderList;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleValuesService;

public class OverrideValuesProvider
extends PossibleValuesService {
    String parentPath;
    String attributePath;
    String valuePath;
    String severity;

    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        if (this.severity != null) {
            if ("ok".equals(this.severity) || "info".equals(this.severity)) {
                return Status.Severity.OK;
            }
            if ("warning".equals(this.severity)) {
                return Status.Severity.WARNING;
            }
        }
        return super.getInvalidValueSeverity(invalidValue);
    }

    protected void init() {
        super.init();
        this.parentPath = this.param("parentPath");
        this.attributePath = this.param("attributePath");
        this.valuePath = this.param("valuePath");
        this.severity = this.param("severity");
        if ("cluster-config/filters".equals(this.parentPath)) {
            ICoherenceCacheConfig root = (ICoherenceCacheConfig)((Element)this.context(Element.class)).nearest(ICoherenceCacheConfig.class);
            OverrideValuesProviderList list = (OverrideValuesProviderList)root.getOverrideValueProviderList().content();
            if (list == null) {
                list = new OverrideValuesProviderList(this);
                root.setOverrideValueProviderList(list);
            } else {
                list.add(this);
            }
        }
    }

    public void dispose() {
        ICoherenceCacheConfig root;
        OverrideValuesProviderList list;
        super.dispose();
        if ("cluster-config/filters".equals(this.parentPath) && (list = (OverrideValuesProviderList)(root = (ICoherenceCacheConfig)((Element)this.context(Element.class)).nearest(ICoherenceCacheConfig.class)).getOverrideValueProviderList().content()) != null) {
            list.remove(this);
        }
    }

    protected void fillPossibleValues(Set<String> values) {
        IProject project;
        Element element = (Element)this.context(Element.class);
        if (element != null && (project = (IProject)element.adapt(IProject.class)) != null) {
            for (String value : CoherenceCacheConfigService.getListOfValues(project, this.parentPath, this.attributePath, this.valuePath)) {
                values.add(value);
            }
        }
    }

    public void refreshAll() {
        this.broadcast();
    }
}

