/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamType;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberWithUnit;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.VersionCompatibilityService;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.services.DefaultValueService;

public class NumberWithUnitPropertyCustomBinding
extends ParamTypeCustomBinding {
    private boolean isNumber;

    @Override
    public void init(Property property) {
        String[] params = ((CustomXmlValueBinding)property.definition().getAnnotation(CustomXmlValueBinding.class)).params();
        boolean isParamTypeName = false;
        if (params.length > 1) {
            this.isNumber = Boolean.parseBoolean(params[1]);
            if (params.length > 2) {
                isParamTypeName = params[2].equals("true");
            }
        }
        super.init(property);
        this.setIsParamTypeName(isParamTypeName);
    }

    private NumberWithUnit getDefaultNumberWithUnit() {
        DefaultValueService unitService;
        Property unitProperty;
        Property numberProperty;
        Element element = this.property().element();
        String propertyName = this.property().name();
        if (this.isNumber) {
            numberProperty = element.property(propertyName);
            unitProperty = element.property(String.valueOf(propertyName) + "Unit");
        } else {
            unitProperty = element.property(propertyName);
            numberProperty = element.property(propertyName.substring(0, propertyName.length() - 4));
        }
        DefaultValueService numberService = (DefaultValueService)numberProperty.service(DefaultValueService.class);
        String defaultNumber = null;
        if (numberService != null) {
            defaultNumber = numberService.value();
        }
        String defaultUnit = (unitService = (DefaultValueService)unitProperty.service(DefaultValueService.class)) != null && this.unitEnabled(unitProperty) ? unitService.value() : null;
        return new NumberWithUnit(defaultNumber, defaultUnit);
    }

    private boolean unitEnabled(Property unitProperty) {
        VersionCompatibilityService vcService = (VersionCompatibilityService)unitProperty.service(VersionCompatibilityService.class);
        return vcService != null ? vcService.compatible() : true;
    }

    @Override
    public String read() {
        ParamType paramType = this.readParamType();
        if (this.isParamTypeName()) {
            return paramType.getName();
        }
        String value = paramType.getValue();
        NumberWithUnit nu = NumberWithUnit.parse(value);
        if (this.isNumber) {
            return nu.getNumber();
        }
        return nu.getUnit();
    }

    private boolean isValidNumber(String value) {
        if (this.isNumber) {
            if (value == null) {
                return false;
            }
            ValueProperty numberProp = (ValueProperty)this.property().definition();
            if (numberProp.isOfType(Long.class)) {
                long number = 0L;
                try {
                    number = Long.parseLong(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return number > 0L;
            }
            if (numberProp.isOfType(Integer.class)) {
                int number = 0;
                try {
                    number = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return number > 0;
            }
            if (numberProp.isOfType(BigDecimal.class)) {
                BigDecimal number = BigDecimal.ZERO;
                try {
                    number = new BigDecimal(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return number.compareTo(BigDecimal.ZERO) > 0;
            }
        }
        return true;
    }

    @Override
    public void write(String value) {
        if (!this.isParamTypeName()) {
            ParamType paramType = this.readParamType();
            if (this.isNumber) {
                if (value != null && value.length() > 0 && this.isValidNumber(value)) {
                    String oldValue = paramType.getValue();
                    NumberWithUnit nu = NumberWithUnit.parse(oldValue);
                    nu.setNumber(value);
                    if (nu.getNumber() == null || nu.getUnit() == null) {
                        nu.addDefault(this.getDefaultNumberWithUnit());
                    }
                    value = nu.toString();
                }
            } else {
                String oldValue = paramType.getValue();
                NumberWithUnit nu = NumberWithUnit.parse(oldValue);
                nu.setUnit(value);
                if (nu.getNumber() == null || nu.getUnit() == null) {
                    nu.addDefault(this.getDefaultNumberWithUnit());
                }
                value = nu.toString();
            }
        }
        super.write(value);
    }
}

