/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.ILocalAddress;
import oracle.eclipse.tools.coherence.descriptors.IModelElementBase;
import oracle.eclipse.tools.coherence.descriptors.IRemoteAddresses;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderInstance;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSdp;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSsl;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSystem;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderTcp;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.INameServiceAddresses;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISocketProviderCacheConfigName;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.CacheConfigSocketProviderNamePossibleTypesService;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.TcpInitiatorRemoteAddressPossibleTypesService;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.internal.TextAndElementBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

public interface ITcpInitiator
extends Element {
    public static final ElementType TYPE = new ElementType(ITcpInitiator.class);
    @Type(base=IModelElementBase.class)
    @Service(impl=CacheConfigSocketProviderNamePossibleTypesService.class)
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Label(standard="socket provider")
    @Since(value="3.6")
    @XmlElementBinding(path="socket-provider", mappings={@XmlElementBinding.Mapping(element="$$ANY", type=ISocketProviderCacheConfigName.class), @XmlElementBinding.Mapping(element="system", type=ISocketProviderSystem.class), @XmlElementBinding.Mapping(element="ssl", type=ISocketProviderSsl.class), @XmlElementBinding.Mapping(element="tcp", type=ISocketProviderTcp.class), @XmlElementBinding.Mapping(element="sdp", type=ISocketProviderSdp.class), @XmlElementBinding.Mapping(element="instance", type=ISocketProviderInstance.class)})
    public static final ElementProperty PROP_SOCKET_PROVIDER = new ElementProperty(TYPE, "SocketProvider");
    @Type(base=ILocalAddress.class)
    @XmlBinding(path="local-address")
    @Label(standard="local address")
    public static final ElementProperty PROP_LOCAL_ADDRESS = new ElementProperty(TYPE, "LocalAddress");
    @Type(base=IModelElementBase.class)
    @Service(impl=TcpInitiatorRemoteAddressPossibleTypesService.class)
    @Label(standard="addresses")
    @Required
    @XmlElementBinding(path="", mappings={@XmlElementBinding.Mapping(element="remote-addresses", type=IRemoteAddresses.class), @XmlElementBinding.Mapping(element="name-service-addresses", type=INameServiceAddresses.class)})
    public static final ElementProperty PROP_REMOTE_ADDRESS = new ElementProperty(TYPE, "RemoteAddress");
    @Type(base=Boolean.class)
    @XmlBinding(path="reuse-address")
    @Label(standard="reuse address")
    @DefaultValue(text="true")
    @Documentation(content="Specifies whether or not a TCP/IP socket can be bound to an address if a previous connection is in a timeout state.")
    public static final ValueProperty PROP_REUSE_ADDRESS = new ValueProperty(TYPE, "ReuseAddress");
    @Type(base=Boolean.class)
    @XmlBinding(path="keep-alive-enabled")
    @Label(standard="keep alive enabled")
    @DefaultValue(text="true")
    @Documentation(content="Specifies whether or not keep alive (SO_KEEPALIVE) is enabled on a TCP/IP socket.")
    public static final ValueProperty PROP_KEEP_ALIVE_ENABLED = new ValueProperty(TYPE, "KeepAliveEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="tcp-delay-enabled")
    @Label(standard="TCP delay enabled")
    @DefaultValue(text="false")
    @Documentation(content="Specifies whether or not TCP delay (Nagle's algorithm) is enabled on a TCP/IP socket.")
    public static final ValueProperty PROP_TCP_DELAY_ENABLED = new ValueProperty(TYPE, "TcpDelayEnabled");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"receive-buffer-size", "true"})
    @Label(standard="receive buffer size")
    @NumericRange(min="0")
    @Documentation(content="Specifieds the size of the underlying TCP/IP socket network receive buffer.[pbr/]Increasing the receive buffer size can increase the performance of network I/O for high-volume connections, while decreasing it can help reduce the backlog of incoming data.")
    public static final ValueProperty PROP_RECEIVE_BUFFER_SIZE = new ValueProperty(TYPE, "ReceiveBufferSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"receive-buffer-size", "false"})
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="ReceiveBufferSize")})
    public static final ValueProperty PROP_RECEIVE_BUFFER_SIZE_UNIT = new ValueProperty(TYPE, "ReceiveBufferSizeUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"receive-buffer-size", "true", "true"})
    public static final ValueProperty PROP_RECEIVE_BUFFER_SIZE_PARAM = new ValueProperty(TYPE, "ReceiveBufferSizeParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"send-buffer-size", "true"})
    @Label(standard="send buffer size")
    @NumericRange(min="0")
    @Documentation(content="Specifieds the size of the underlying TCP/IP socket network send buffer.")
    public static final ValueProperty PROP_SEND_BUFFER_SIZE = new ValueProperty(TYPE, "SendBufferSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"send-buffer-size", "false"})
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="SendBufferSize")})
    public static final ValueProperty PROP_SEND_BUFFER_SIZE_UNIT = new ValueProperty(TYPE, "SendBufferSizeUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"send-buffer-size", "true", "true"})
    public static final ValueProperty PROP_SEND_BUFFER_SIZE_PARAM = new ValueProperty(TYPE, "SendBufferSizeParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"connect-timeout", "true"})
    @Label(standard="connect timeout")
    @NumericRange(min="0")
    @Documentation(content="Specifies the maximum amount of time to wait while establishing a connection with a connection acceptor.")
    public static final ValueProperty PROP_CONNECT_TIMEOUT = new ValueProperty(TYPE, "ConnectTimeout");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"connect-timeout", "false"})
    @DefaultValue(text="ms")
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="ConnectTimeout")})
    public static final ValueProperty PROP_CONNECT_TIMEOUT_UNIT = new ValueProperty(TYPE, "ConnectTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"connect-timeout", "true", "true"})
    public static final ValueProperty PROP_CONNECT_TIMEOUT_PARAM = new ValueProperty(TYPE, "ConnectTimeoutParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"linger-timeout", "true"})
    @Label(standard="linger timeout")
    @NumericRange(min="0")
    @Documentation(content="Specifies the SO_LINGER on a TCP/IP socket with the specified linger time.")
    public static final ValueProperty PROP_LINGER_TIMEOUT = new ValueProperty(TYPE, "LingerTimeout");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"linger-timeout", "false"})
    @DefaultValue(text="ms")
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="LingerTimeout")})
    public static final ValueProperty PROP_LINGER_TIMEOUT_UNIT = new ValueProperty(TYPE, "LingerTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"linger-timeout", "true", "true"})
    public static final ValueProperty PROP_LINGER_TIMEOUT_PARAM = new ValueProperty(TYPE, "LingerTimeoutParam");

    public ElementHandle<IModelElementBase> getSocketProvider();

    public ElementHandle<ILocalAddress> getLocalAddress();

    public ElementHandle<IModelElementBase> getRemoteAddress();

    public Value<Boolean> getReuseAddress();

    public void setReuseAddress(String var1);

    public void setReuseAddress(Boolean var1);

    public Value<Boolean> getKeepAliveEnabled();

    public void setKeepAliveEnabled(String var1);

    public void setKeepAliveEnabled(Boolean var1);

    public Value<Boolean> getTcpDelayEnabled();

    public void setTcpDelayEnabled(String var1);

    public void setTcpDelayEnabled(Boolean var1);

    public Value<BigDecimal> getReceiveBufferSize();

    public void setReceiveBufferSize(String var1);

    public void setReceiveBufferSize(BigDecimal var1);

    public Value<SizeUnit> getReceiveBufferSizeUnit();

    public void setReceiveBufferSizeUnit(String var1);

    public void setReceiveBufferSizeUnit(SizeUnit var1);

    public Value<String> getReceiveBufferSizeParam();

    public void setReceiveBufferSizeParam(String var1);

    public Value<BigDecimal> getSendBufferSize();

    public void setSendBufferSize(String var1);

    public void setSendBufferSize(BigDecimal var1);

    public Value<SizeUnit> getSendBufferSizeUnit();

    public void setSendBufferSizeUnit(String var1);

    public void setSendBufferSizeUnit(SizeUnit var1);

    public Value<String> getSendBufferSizeParam();

    public void setSendBufferSizeParam(String var1);

    public Value<BigDecimal> getConnectTimeout();

    public void setConnectTimeout(String var1);

    public void setConnectTimeout(BigDecimal var1);

    public Value<TimeUnit> getConnectTimeoutUnit();

    public void setConnectTimeoutUnit(String var1);

    public void setConnectTimeoutUnit(TimeUnit var1);

    public Value<String> getConnectTimeoutParam();

    public void setConnectTimeoutParam(String var1);

    public Value<BigDecimal> getLingerTimeout();

    public void setLingerTimeout(String var1);

    public void setLingerTimeout(BigDecimal var1);

    public Value<TimeUnit> getLingerTimeoutUnit();

    public void setLingerTimeoutUnit(String var1);

    public void setLingerTimeoutUnit(TimeUnit var1);

    public Value<String> getLingerTimeoutParam();

    public void setLingerTimeoutParam(String var1);
}

