/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.ILocalAddress;
import oracle.eclipse.tools.coherence.descriptors.IModelElementBase;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderInstance;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSdp;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSsl;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderSystem;
import oracle.eclipse.tools.coherence.descriptors.ISocketProviderTcp;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IAddressProviderInstance;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IAddressProviderName;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IAuthorizedHosts;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISocketProviderCacheConfigName;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.CacheConfigSocketProviderNamePossibleTypesService;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.TcpAddressPossibleTypesService;
import oracle.eclipse.tools.coherence.descriptors.internal.AddressProviderElementBinding;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.internal.TextAndElementBinding;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

@Label(standard="TCP Acceptor")
public interface ITcpAcceptor
extends IModelElementBase {
    public static final ElementType TYPE = new ElementType(ITcpAcceptor.class);
    @Type(base=IModelElementBase.class)
    @Service(impl=CacheConfigSocketProviderNamePossibleTypesService.class)
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Label(standard="socket provider")
    @Since(value="3.6")
    @XmlElementBinding(path="socket-provider", mappings={@XmlElementBinding.Mapping(element="$$ANY", type=ISocketProviderCacheConfigName.class), @XmlElementBinding.Mapping(element="system", type=ISocketProviderSystem.class), @XmlElementBinding.Mapping(element="ssl", type=ISocketProviderSsl.class), @XmlElementBinding.Mapping(element="tcp", type=ISocketProviderTcp.class), @XmlElementBinding.Mapping(element="sdp", type=ISocketProviderSdp.class), @XmlElementBinding.Mapping(element="instance", type=ISocketProviderInstance.class)})
    public static final ElementProperty PROP_SOCKET_PROVIDER = new ElementProperty(TYPE, "SocketProvider");
    @Type(base=IModelElementBase.class)
    @Service(impl=TcpAddressPossibleTypesService.class)
    @CustomXmlElementBinding(impl=AddressProviderElementBinding.class)
    @Label(standard="TCP address")
    @XmlElementBinding(path="", mappings={@XmlElementBinding.Mapping(element="local-address", type=ILocalAddress.class), @XmlElementBinding.Mapping(element="$$address-provider-instance", type=IAddressProviderInstance.class), @XmlElementBinding.Mapping(element="$$address-provider-name", type=IAddressProviderName.class)})
    public static final ElementProperty PROP_TCP_ADDRESS = new ElementProperty(TYPE, "TcpAddress");
    @Type(base=Boolean.class)
    @XmlBinding(path="reuse-address")
    @Label(standard="reuse address")
    @DefaultValue(text="false")
    @Documentation(content="Specifies whether or not a TCP/IP socket can be bound to an address if a previous connection is in a timeout state.")
    public static final ValueProperty PROP_REUSE_ADDRESS = new ValueProperty(TYPE, "ReuseAddress");
    @Type(base=Boolean.class)
    @XmlBinding(path="keep-alive-enabled")
    @Label(standard="keep alive enabled")
    @DefaultValue(text="true")
    @Documentation(content="Specifies whether or not keep alive (SO_KEEPALIVE) is enabled on a TCP/IP socket.")
    public static final ValueProperty PROP_KEEP_ALIVE_ENABLED = new ValueProperty(TYPE, "KeepAliveEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="tcp-delay-enabled")
    @Label(standard="TCP delay enabled")
    @DefaultValue(text="false")
    @Documentation(content="Specifies whether or not TCP delay (Nagle's algorithm) is enabled on a TCP/IP socket.")
    public static final ValueProperty PROP_TCP_DELAY_ENABLED = new ValueProperty(TYPE, "TcpDelayEnabled");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"receive-buffer-size", "true"})
    @Label(standard="receive buffer size")
    @NumericRange(min="0")
    @Documentation(content="Specifieds the size of the underlying TCP/IP socket network receive buffer.[pbr/]Increasing the receive buffer size can increase the performance of network I/O for high-volume connections, while decreasing it can help reduce the backlog of incoming data.")
    public static final ValueProperty PROP_RECEIVE_BUFFER_SIZE = new ValueProperty(TYPE, "ReceiveBufferSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"receive-buffer-size", "false"})
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="ReceiveBufferSize")})
    public static final ValueProperty PROP_RECEIVE_BUFFER_SIZE_UNIT = new ValueProperty(TYPE, "ReceiveBufferSizeUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"receive-buffer-size", "true", "true"})
    public static final ValueProperty PROP_RECEIVE_BUFFER_SIZE_PARAM = new ValueProperty(TYPE, "ReceiveBufferSizeParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"send-buffer-size", "true"})
    @Label(standard="send buffer size")
    @NumericRange(min="0")
    @Documentation(content="Specifieds the size of the underlying TCP/IP socket network send buffer.")
    public static final ValueProperty PROP_SEND_BUFFER_SIZE = new ValueProperty(TYPE, "SendBufferSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"send-buffer-size", "false"})
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="SendBufferSize")})
    public static final ValueProperty PROP_SEND_BUFFER_SIZE_UNIT = new ValueProperty(TYPE, "SendBufferSizeUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"send-buffer-size", "true", "true"})
    public static final ValueProperty PROP_SEND_BUFFER_SIZE_PARAM = new ValueProperty(TYPE, "SendBufferSizeParam");
    @Type(base=Integer.class)
    @XmlBinding(path="listen-backlog")
    @Label(standard="listen backlog")
    @NumericRange(min="1")
    @Documentation(content="Specifies the size of the TCP/IP server socket backlog queue.")
    public static final ValueProperty PROP_LISTEN_BACKLOG = new ValueProperty(TYPE, "ListenBacklog");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"linger-timeout", "true"})
    @Label(standard="linger timeout")
    @NumericRange(min="0")
    @Documentation(content="Specifies the SO_LINGER on a TCP/IP socket with the specified linger time.")
    public static final ValueProperty PROP_LINGER_TIMEOUT = new ValueProperty(TYPE, "LingerTimeout");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"linger-timeout", "false"})
    @DefaultValue(text="ms")
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="LingerTimeout")})
    public static final ValueProperty PROP_LINGER_TIMEOUT_UNIT = new ValueProperty(TYPE, "LingerTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"linger-timeout", "true", "true"})
    public static final ValueProperty PROP_LINGER_TIMEOUT_PARAM = new ValueProperty(TYPE, "LingerTimeoutParam");
    @Type(base=IAuthorizedHosts.class)
    @XmlBinding(path="authorized-hosts")
    public static final ImpliedElementProperty PROP_AUTHORIZED_HOSTS = new ImpliedElementProperty(TYPE, "AuthorizedHosts");
    @Type(base=Boolean.class)
    @XmlBinding(path="suspect-protocol-enabled")
    @Label(standard="suspect protocol enabled")
    @DefaultValue(text="true")
    @Since(value="3.6")
    @Documentation(content="Enable or disable the Coherence*Extend-TCP rogue client connection  detection algorithm. This algorithm monitors client connections looking for abnormally slow or abusive clients. When a rouge client connection is detected, the algorithm closes the connection in order to protect the proxy server from running out of memory.")
    public static final ValueProperty PROP_SUSPECT_PROTOCOL_ENABLED = new ValueProperty(TYPE, "SuspectProtocolEnabled");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"suspect-buffer-size", "true"})
    @Label(standard="suspect buffer size")
    @DefaultValue(text="10000000")
    @NumericRange(min="0")
    @Since(value="3.6")
    @Documentation(content="Specifies the outgoing  connection backlog (in bytes) after which the corresponding client connection is marked as suspect. A suspect client connection is then monitored until it is no longer suspect or it is closed in order to protect the proxy server from running out of memory.")
    public static final ValueProperty PROP_SUSPECT_BUFFER_SIZE = new ValueProperty(TYPE, "SuspectBufferSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"suspect-buffer-size", "false"})
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="SuspectBufferSize")})
    public static final ValueProperty PROP_SUSPECT_BUFFER_SIZE_UNIT = new ValueProperty(TYPE, "SuspectBufferSizeUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"suspect-buffer-size", "true", "true"})
    public static final ValueProperty PROP_SUSPECT_BUFFER_SIZE_PARAM = new ValueProperty(TYPE, "SuspectBufferSizeParam");
    @Type(base=Integer.class)
    @XmlBinding(path="suspect-buffer-length")
    @Label(standard="suspect buffer length")
    @DefaultValue(text="10000")
    @Since(value="3.6")
    @Documentation(content="Specifies the outgoing connection backlog (in messages) after which the corresponding client connection is marked as suspect. A suspect client connection is then monitored until it is no longer suspect or it is closed in order to protect the proxy server from running out of memory.")
    public static final ValueProperty PROP_SUSPECT_BUFFER_LENGTH = new ValueProperty(TYPE, "SuspectBufferLength");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"nominal-buffer-size", "true"})
    @Label(standard="nominal buffer size")
    @DefaultValue(text="2000000")
    @NumericRange(min="0")
    @Since(value="3.6")
    @Documentation(content="Specifies the outgoing connection backlog (in bytes) at which point a suspect client connection is no longer considered to be suspect.")
    public static final ValueProperty PROP_NOMINAL_BUFFER_SIZE = new ValueProperty(TYPE, "NominalBufferSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"nominal-buffer-size", "false"})
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="NominalBufferSize")})
    public static final ValueProperty PROP_NOMINAL_BUFFER_SIZE_UNIT = new ValueProperty(TYPE, "NominalBufferSizeUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"nominal-buffer-size", "true", "true"})
    public static final ValueProperty PROP_NOMINAL_BUFFER_SIZE_PARAM = new ValueProperty(TYPE, "NominalBufferSizeParam");
    @Type(base=Integer.class)
    @XmlBinding(path="nominal-buffer-length")
    @Label(standard="nominal buffer length")
    @DefaultValue(text="2000")
    @Since(value="3.6")
    @Documentation(content="Specifies the outgoing connection backlog (in messages) at which point a suspect client connection is no longer considered to be suspect.")
    public static final ValueProperty PROP_NOMINAL_BUFFER_LENGTH = new ValueProperty(TYPE, "NominalBufferLength");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"limit-buffer-size", "true"})
    @Label(standard="limit buffer size")
    @DefaultValue(text="100000000")
    @NumericRange(min="0")
    @Since(value="3.6")
    @Documentation(content="Specifies the outgoing connection backlog (in bytes) at which point the corresponding client connection must be closed in order to protect the proxy server from running out of memory.")
    public static final ValueProperty PROP_LIMIT_BUFFER_SIZE = new ValueProperty(TYPE, "LimitBufferSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"limit-buffer-size", "false"})
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="LimitBufferSize")})
    public static final ValueProperty PROP_LIMIT_BUFFER_SIZE_UNIT = new ValueProperty(TYPE, "LimitBufferSizeUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"limit-buffer-size", "true", "true"})
    public static final ValueProperty PROP_LIMIT_BUFFER_SIZE_PARAM = new ValueProperty(TYPE, "LimitBufferSizeParam");
    @Type(base=Integer.class)
    @XmlBinding(path="limit-buffer-length")
    @Label(standard="limit buffer length")
    @DefaultValue(text="60000")
    @Since(value="3.6")
    @Documentation(content="Specifies the outgoing connection backlog (in messages) at which point the corresponding client connection must be closed in order to protect the proxy server from running out of memory.")
    public static final ValueProperty PROP_LIMIT_BUFFER_LENGTH = new ValueProperty(TYPE, "LimitBufferLength");

    public ElementHandle<IModelElementBase> getSocketProvider();

    public ElementHandle<IModelElementBase> getTcpAddress();

    public Value<Boolean> getReuseAddress();

    public void setReuseAddress(String var1);

    public void setReuseAddress(Boolean var1);

    public Value<Boolean> getKeepAliveEnabled();

    public void setKeepAliveEnabled(String var1);

    public void setKeepAliveEnabled(Boolean var1);

    public Value<Boolean> getTcpDelayEnabled();

    public void setTcpDelayEnabled(String var1);

    public void setTcpDelayEnabled(Boolean var1);

    public Value<BigDecimal> getReceiveBufferSize();

    public void setReceiveBufferSize(String var1);

    public void setReceiveBufferSize(BigDecimal var1);

    public Value<SizeUnit> getReceiveBufferSizeUnit();

    public void setReceiveBufferSizeUnit(String var1);

    public void setReceiveBufferSizeUnit(SizeUnit var1);

    public Value<String> getReceiveBufferSizeParam();

    public void setReceiveBufferSizeParam(String var1);

    public Value<BigDecimal> getSendBufferSize();

    public void setSendBufferSize(String var1);

    public void setSendBufferSize(BigDecimal var1);

    public Value<SizeUnit> getSendBufferSizeUnit();

    public void setSendBufferSizeUnit(String var1);

    public void setSendBufferSizeUnit(SizeUnit var1);

    public Value<String> getSendBufferSizeParam();

    public void setSendBufferSizeParam(String var1);

    public Value<Integer> getListenBacklog();

    public void setListenBacklog(String var1);

    public void setListenBacklog(Integer var1);

    public Value<BigDecimal> getLingerTimeout();

    public void setLingerTimeout(String var1);

    public void setLingerTimeout(BigDecimal var1);

    public Value<TimeUnit> getLingerTimeoutUnit();

    public void setLingerTimeoutUnit(String var1);

    public void setLingerTimeoutUnit(TimeUnit var1);

    public Value<String> getLingerTimeoutParam();

    public void setLingerTimeoutParam(String var1);

    public IAuthorizedHosts getAuthorizedHosts();

    public Value<Boolean> getSuspectProtocolEnabled();

    public void setSuspectProtocolEnabled(String var1);

    public void setSuspectProtocolEnabled(Boolean var1);

    public Value<BigDecimal> getSuspectBufferSize();

    public void setSuspectBufferSize(String var1);

    public void setSuspectBufferSize(BigDecimal var1);

    public Value<SizeUnit> getSuspectBufferSizeUnit();

    public void setSuspectBufferSizeUnit(String var1);

    public void setSuspectBufferSizeUnit(SizeUnit var1);

    public Value<String> getSuspectBufferSizeParam();

    public void setSuspectBufferSizeParam(String var1);

    public Value<Integer> getSuspectBufferLength();

    public void setSuspectBufferLength(String var1);

    public void setSuspectBufferLength(Integer var1);

    public Value<BigDecimal> getNominalBufferSize();

    public void setNominalBufferSize(String var1);

    public void setNominalBufferSize(BigDecimal var1);

    public Value<SizeUnit> getNominalBufferSizeUnit();

    public void setNominalBufferSizeUnit(String var1);

    public void setNominalBufferSizeUnit(SizeUnit var1);

    public Value<String> getNominalBufferSizeParam();

    public void setNominalBufferSizeParam(String var1);

    public Value<Integer> getNominalBufferLength();

    public void setNominalBufferLength(String var1);

    public void setNominalBufferLength(Integer var1);

    public Value<BigDecimal> getLimitBufferSize();

    public void setLimitBufferSize(String var1);

    public void setLimitBufferSize(BigDecimal var1);

    public Value<SizeUnit> getLimitBufferSizeUnit();

    public void setLimitBufferSizeUnit(String var1);

    public void setLimitBufferSizeUnit(SizeUnit var1);

    public Value<String> getLimitBufferSizeParam();

    public void setLimitBufferSizeParam(String var1);

    public Value<Integer> getLimitBufferLength();

    public void setLimitBufferLength(String var1);

    public void setLimitBufferLength(Integer var1);
}

