/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.IModelElementBase;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyExitCluster;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyExitProcess;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyInstance;
import oracle.eclipse.tools.coherence.descriptors.IServiceFailurePolicyLogging;
import oracle.eclipse.tools.coherence.descriptors.LeaseGranularity;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IBackingMapSchemeInline;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IMemberListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISerializer35;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISerializerInstance;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ISerializerName;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.OverrideValuesProvider;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemeRefDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.internal.TextAndElementBinding;
import oracle.eclipse.tools.coherence.descriptors.override.ReliableTransport;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

public interface IReplicatedScheme
extends ICachingScheme {
    public static final ElementType TYPE = new ElementType(IReplicatedScheme.class);
    @XmlBinding(path="service-name")
    @Label(standard="service")
    @Service(impl=OverrideValuesProvider.class, params={@Service.Param(name="parentPath", value="cluster-config/services"), @Service.Param(name="attributePath", value="id"), @Service.Param(name="valuePath", value="service-type"), @Service.Param(name="severity", value="ok")})
    @Documentation(content="Specifies the name of the service which manages caches created from this scheme.")
    public static final ValueProperty PROP_SERVICE_NAME = new ValueProperty(TYPE, "ServiceName");
    @Type(base=ISerializer35.class)
    @XmlBinding(path="serializer")
    @Documentation(content="Specifies the class configuration info for a com.tangosol.io.Serializer implementation.")
    public static final ImpliedElementProperty PROP_SERIALIZER35 = new ImpliedElementProperty(TYPE, "Serializer35");
    @Type(base=IModelElementBase.class, possible={ISerializerName.class, ISerializerInstance.class})
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Since(value="3.6")
    @Label(standard="serializer")
    @XmlElementBinding(path="serializer", mappings={@XmlElementBinding.Mapping(element="$$ANY", type=ISerializerName.class), @XmlElementBinding.Mapping(element="instance", type=ISerializerInstance.class)})
    public static final ElementProperty PROP_SERIALIZER = new ElementProperty(TYPE, "Serializer");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"standard-lease-milliseconds"})
    @Label(standard="standard lease (ms)")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(1)/init-params/init-param(1)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReplicatedScheme]/StandardLease")})
    @Documentation(content="Specifies the duration of the standard lease in milliseconds. When a lease has aged past this number of milliseconds, the lock is automatically released. Set this value to zero to specify a lease that never expires. The purpose of this setting is to avoid deadlocks or blocks caused by stuck threads; the value should be set higher than the longest expected lock duration (for example, higher than a transaction timeout). It's also recommended to set this value higher than packet-delivery/timeout-milliseconds value. ")
    public static final ValueProperty PROP_STANDARD_LEASE = new ValueProperty(TYPE, "StandardLease");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"standard-lease-milliseconds", "true"})
    public static final ValueProperty PROP_STANDARD_LEASE_PARAM = new ValueProperty(TYPE, "StandardLeaseParam");
    @Type(base=LeaseGranularity.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"lease-granularity"})
    @Label(standard="lease granularity")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(1)/init-params/init-param(2)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReplicatedScheme]/LeaseGranularity")})
    @Documentation(content="Specifies the lease ownership granularity.[pbr/]Legal values are: [ul][li]thread: locks are held by a thread that obtained them and can only be released by that thread.[/li][li]member: locks are held by a cluster node and any thread running on the cluster node that obtained the lock can release it.[/li][/ul]")
    public static final ValueProperty PROP_LEASE_GRANULARITY = new ValueProperty(TYPE, "LeaseGranularity");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"lease-granularity", "true"})
    public static final ValueProperty PROP_LEASE_GRANULARITY_PARAM = new ValueProperty(TYPE, "LeaseGranularityParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"request-timeout", "true"})
    @Label(standard="request timeout")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(1)/init-params/init-param(4)/param-value"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReplicatedScheme]/RequestTimeout")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the maximum amount of time a client waits for a response before abandoning the original request. The request time is measured on the client side as the time elapsed from the moment a request is sent for execution to the corresponding server node(s) and includes the following:[ul][li]the time it takes to deliver the request to an executing node (server) [/li][li]the interval between the time the task is received and placed into a service queue until the execution starts [/li][li]the task execution time [/li][li]the time it takes to deliver a result back to the client [/li][/ul]")
    public static final ValueProperty PROP_REQUEST_TIMEOUT = new ValueProperty(TYPE, "RequestTimeout");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"request-timeout", "false"})
    @DefaultValue(text="ms")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(1)/init-params/init-param(4)/param-value"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReplicatedScheme]/RequestTimeoutUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="RequestTimeout")})})
    public static final ValueProperty PROP_REQUEST_TIMEOUT_UNIT = new ValueProperty(TYPE, "RequestTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"request-timeout", "true", "true"})
    public static final ValueProperty PROP_REQUEST_TIMEOUT_PARAM = new ValueProperty(TYPE, "RequestTimeoutParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"guardian-timeout", "true"})
    @Label(standard="guardian timeout")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/service-guardian/timeout-milliseconds"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReplicatedScheme]/GuardianTimeout")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the the guardian timeout value to use for guarding the service and any dependant threads.")
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT = new ValueProperty(TYPE, "GuardianTimeout");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"guardian-timeout", "false"})
    @DefaultValue(text="ms")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/service-guardian/timeout-milliseconds"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReplicatedScheme]/GuardianTimeoutUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="GuardianTimeout")})})
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT_UNIT = new ValueProperty(TYPE, "GuardianTimeoutUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"guardian-timeout", "true", "true"})
    public static final ValueProperty PROP_GUARDIAN_TIMEOUT_PARAM = new ValueProperty(TYPE, "GuardianTimeoutParam");
    @Type(base=IModelElementBase.class, possible={IServiceFailurePolicyExitProcess.class, IServiceFailurePolicyExitCluster.class, IServiceFailurePolicyLogging.class, IServiceFailurePolicyInstance.class})
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Since(value="3.6")
    @Label(standard="service failure policy")
    @XmlElementBinding(path="service-failure-policy", mappings={@XmlElementBinding.Mapping(element="$$exit-process", type=IServiceFailurePolicyExitProcess.class), @XmlElementBinding.Mapping(element="$$exit-cluster", type=IServiceFailurePolicyExitCluster.class), @XmlElementBinding.Mapping(element="$$logging", type=IServiceFailurePolicyLogging.class), @XmlElementBinding.Mapping(element="instance", type=IServiceFailurePolicyInstance.class)})
    public static final ElementProperty PROP_SERVICE_FAILURE_POLICY = new ElementProperty(TYPE, "ServiceFailurePolicy");
    @Type(base=IMemberListener.class)
    @XmlBinding(path="member-listener")
    @Since(value="3.6")
    public static final ElementProperty PROP_MEMBER_LISTENER = new ElementProperty(TYPE, "MemberListener");
    @Type(base=IBackingMapSchemeInline.class)
    @XmlBinding(path="backing-map-scheme")
    public static final ImpliedElementProperty PROP_BACKING_MAP_SCHEME_INLINE = new ImpliedElementProperty(TYPE, "BackingMapSchemeInline");
    @Type(base=IListener.class)
    @XmlBinding(path="listener/class-scheme")
    public static final ImpliedElementProperty PROP_LISTENER = new ImpliedElementProperty(TYPE, "Listener");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"autostart"})
    @Label(standard="autostart")
    @DefaultValue(text="false")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReplicatedScheme]/Autostart")})
    @Documentation(content="Specifies whether or not the cache services associated with the cache scheme should be automatically started at a cluster node.")
    public static final ValueProperty PROP_AUTOSTART = new ValueProperty(TYPE, "Autostart");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"autostart", "true"})
    public static final ValueProperty PROP_AUTOSTART_PARAM = new ValueProperty(TYPE, "AutostartParam");
    @Type(base=Integer.class)
    @Label(standard="service priority")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"service-priority"})
    @NumericRange(min="1", max="10")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(1)/init-params/init-param(9)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReplicatedScheme]/ServicePriority")})
    @Since(value="12.1.2")
    @Documentation(content="specifies the priority for the service thread.")
    public static final ValueProperty PROP_SERVICE_PRIORITY = new ValueProperty(TYPE, "ServicePriority");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"service-priority", "true"})
    public static final ValueProperty PROP_SERVICE_PRIORITY_PARAM = new ValueProperty(TYPE, "ServicePriorityParam");
    @Type(base=Integer.class)
    @Label(standard="event dispatcher priority")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"event-dispatcher-priority"})
    @NumericRange(min="1", max="10")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(1)/init-params/init-param(10)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReplicatedScheme]/EventDispatcherPriority")})
    @Since(value="12.1.2")
    @Documentation(content="specifies the priority for the event dispatcher thread for each service.")
    public static final ValueProperty PROP_EVENT_DISPATCHER_PRIORITY = new ValueProperty(TYPE, "EventDispatcherPriority");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"event-dispatcher-priority", "true"})
    public static final ValueProperty PROP_EVENT_DISPATCHER_PRIORITY_PARAM = new ValueProperty(TYPE, "EventDispatcherPriorityParam");
    @Type(base=ReliableTransport.class)
    @Label(standard="reliable transport")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"reliable-transport"})
    @DefaultValue(text="datagram")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/unicast-listener/reliable-transport"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IReplicatedScheme]/ReliableTransport")})
    @Since(value="12.1.2")
    @Documentation(content="Contains the name of the transport used by the TCMP for reliable point-to-point communications.")
    public static final ValueProperty PROP_RELIABLE_TRANSPORT = new ValueProperty(TYPE, "ReliableTransport");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"reliable-transport", "true"})
    public static final ValueProperty PROP_RELIABLE_TRANSPORT_PARAM = new ValueProperty(TYPE, "ReliableTransportParam");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"scope-name"})
    @Label(standard="scope")
    @Since(value="12.1.2")
    @Documentation(content="The scope-name element contains the scope name for this configuration. The scope name is typically added to the service name (as a prefix) for all services generated by a cache factory.  Scope may be used to isolate services indicated in this cache configuration from services created by cache factories with other configurations, thus avoiding unintended joining of services with similar names from different configurations.")
    public static final ValueProperty PROP_SCOPE_NAME = new ValueProperty(TYPE, "ScopeName");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"scope-name", "true"})
    public static final ValueProperty PROP_SCOPE_NAME_PARAM = new ValueProperty(TYPE, "ScopeNameParam");

    public Value<String> getServiceName();

    public void setServiceName(String var1);

    public ISerializer35 getSerializer35();

    public ElementHandle<IModelElementBase> getSerializer();

    public Value<Integer> getStandardLease();

    public void setStandardLease(String var1);

    public void setStandardLease(Integer var1);

    public Value<String> getStandardLeaseParam();

    public void setStandardLeaseParam(String var1);

    public Value<LeaseGranularity> getLeaseGranularity();

    public void setLeaseGranularity(String var1);

    public void setLeaseGranularity(LeaseGranularity var1);

    public Value<String> getLeaseGranularityParam();

    public void setLeaseGranularityParam(String var1);

    public Value<BigDecimal> getRequestTimeout();

    public void setRequestTimeout(String var1);

    public void setRequestTimeout(BigDecimal var1);

    public Value<TimeUnit> getRequestTimeoutUnit();

    public void setRequestTimeoutUnit(String var1);

    public void setRequestTimeoutUnit(TimeUnit var1);

    public Value<String> getRequestTimeoutParam();

    public void setRequestTimeoutParam(String var1);

    public Value<BigDecimal> getGuardianTimeout();

    public void setGuardianTimeout(String var1);

    public void setGuardianTimeout(BigDecimal var1);

    public Value<TimeUnit> getGuardianTimeoutUnit();

    public void setGuardianTimeoutUnit(String var1);

    public void setGuardianTimeoutUnit(TimeUnit var1);

    public Value<String> getGuardianTimeoutParam();

    public void setGuardianTimeoutParam(String var1);

    public ElementHandle<IModelElementBase> getServiceFailurePolicy();

    public ElementHandle<IMemberListener> getMemberListener();

    public IBackingMapSchemeInline getBackingMapSchemeInline();

    public IListener getListener();

    public Value<Boolean> getAutostart();

    public void setAutostart(String var1);

    public void setAutostart(Boolean var1);

    public Value<String> getAutostartParam();

    public void setAutostartParam(String var1);

    public Value<Integer> getServicePriority();

    public void setServicePriority(String var1);

    public void setServicePriority(Integer var1);

    public Value<String> getServicePriorityParam();

    public void setServicePriorityParam(String var1);

    public Value<Integer> getEventDispatcherPriority();

    public void setEventDispatcherPriority(String var1);

    public void setEventDispatcherPriority(Integer var1);

    public Value<String> getEventDispatcherPriorityParam();

    public void setEventDispatcherPriorityParam(String var1);

    public Value<ReliableTransport> getReliableTransport();

    public void setReliableTransport(String var1);

    public void setReliableTransport(ReliableTransport var1);

    public Value<String> getReliableTransportParam();

    public void setReliableTransportParam(String var1);

    public Value<String> getScopeName();

    public void setScopeName(String var1);

    public Value<String> getScopeNameParam();

    public void setScopeNameParam(String var1);
}

