/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassInitParam;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IDistributedScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IExternalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IFlashjournalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ILocalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IOptimisticScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IOverflowScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IPagedExternalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IRamjournalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IRemoteCacheScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IReplicatedScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ITransactionalScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.InvalidationStrategy;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NearCachingSchemePossibleTypesService;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemeRefDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemesModelElementHandleValidationService;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

public interface INearScheme
extends ICachingScheme,
IClassInitParam {
    public static final ElementType TYPE = new ElementType(INearScheme.class);
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.cache.NearCache"})
    @Documentation(content="Specifies a custom implementation of the near cache. Any custom implementation must extend the com.tangosol.net.cache.NearCache class and declare the exact same set of public constructors. ")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, IClassInitParam.PROP_CLASS_NAME);
    @Type(base=ICachingScheme.class, possible={IClassScheme.class, ILocalScheme.class})
    @XmlElementBinding(path="front-scheme", mappings={@XmlElementBinding.Mapping(element="class-scheme", type=IClassScheme.class), @XmlElementBinding.Mapping(element="local-scheme", type=ILocalScheme.class)})
    @Label(standard="front scheme")
    public static final ElementProperty PROP_FRONT_SCHEME = new ElementProperty(TYPE, "FrontScheme");
    @Type(base=ICachingScheme.class)
    @Services(value={@Service(impl=NearCachingSchemePossibleTypesService.class), @Service(impl=SchemesModelElementHandleValidationService.class)})
    @XmlElementBinding(path="back-scheme", mappings={@XmlElementBinding.Mapping(element="class-scheme", type=IClassScheme.class), @XmlElementBinding.Mapping(element="distributed-scheme", type=IDistributedScheme.class), @XmlElementBinding.Mapping(element="external-scheme", type=IExternalScheme.class), @XmlElementBinding.Mapping(element="flashjournal-scheme", type=IFlashjournalScheme.class), @XmlElementBinding.Mapping(element="local-scheme", type=ILocalScheme.class), @XmlElementBinding.Mapping(element="optimistic-scheme", type=IOptimisticScheme.class), @XmlElementBinding.Mapping(element="overflow-scheme", type=IOverflowScheme.class), @XmlElementBinding.Mapping(element="paged-external-scheme", type=IPagedExternalScheme.class), @XmlElementBinding.Mapping(element="ramjournal-scheme", type=IRamjournalScheme.class), @XmlElementBinding.Mapping(element="remote-cache-scheme", type=IRemoteCacheScheme.class), @XmlElementBinding.Mapping(element="replicated-scheme", type=IReplicatedScheme.class), @XmlElementBinding.Mapping(element="transactional-scheme", type=ITransactionalScheme.class)})
    @Label(standard="back scheme")
    public static final ElementProperty PROP_BACK_SCHEME = new ElementProperty(TYPE, "BackScheme");
    @Type(base=InvalidationStrategy.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"invalidation-strategy"})
    @Label(standard="invalidation strategy")
    @DefaultValue(text="auto")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=INearScheme]/InvalidationStrategy")})
    @Documentation(content="Specifies the strategy used for a front map invalidation. [pbr/]Legal values are: [ul][li]none: This strategy instructs the cache not to listen for invalidation events at all. This is the best choice for raw performance and scalability when business requirements permit the use of data which might not be absolutely current. Freshness of data can be guaranteed by use of a sufficiently brief eviction policy for the front cache.[/li][li]present: This strategy instructs a near cache to listen to the back cache events related only to the items currently present in the front cache. This strategy works best when each instance of a front cache contains distinct subset of data relative to the other front cache instances (for example, sticky data access patterns).[/li][li]all: This strategy instructs a near cache to listen to all back cache events. This strategy is optimal for read-heavy tiered access patterns where there is significant overlap between the different instances of front caches.[/li][li]auto: This strategy instructs a near cache to switch automatically between Present and All strategies based on the cache statistics.[/li][/ul]")
    public static final ValueProperty PROP_INVALIDATION_STRATEGY = new ValueProperty(TYPE, "InvalidationStrategy");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"invalidation-strategy", "true"})
    public static final ValueProperty PROP_INVALIDATION_STRATEGY_PARAM = new ValueProperty(TYPE, "InvalidationStrategyParam");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"autostart"})
    @Label(standard="autostart")
    @DefaultValue(text="false")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=INearScheme]/Autostart")})
    @Documentation(content="Specifies whether or not the cache services associated with the cache scheme should be automatically started at a cluster node.")
    public static final ValueProperty PROP_AUTOSTART = new ValueProperty(TYPE, "Autostart");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"autostart", "true"})
    public static final ValueProperty PROP_AUTOSTART_PARAM = new ValueProperty(TYPE, "AutostartParam");
    @Type(base=IListener.class)
    @XmlBinding(path="listener/class-scheme")
    public static final ImpliedElementProperty PROP_LISTENER = new ImpliedElementProperty(TYPE, "Listener");

    public ElementHandle<ICachingScheme> getFrontScheme();

    public ElementHandle<ICachingScheme> getBackScheme();

    public Value<InvalidationStrategy> getInvalidationStrategy();

    public void setInvalidationStrategy(String var1);

    public void setInvalidationStrategy(InvalidationStrategy var1);

    public Value<String> getInvalidationStrategyParam();

    public void setInvalidationStrategyParam(String var1);

    public Value<Boolean> getAutostart();

    public void setAutostart(String var1);

    public void setAutostart(Boolean var1);

    public Value<String> getAutostartParam();

    public void setAutostartParam(String var1);

    public IListener getListener();
}

