/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.IModelElementBase;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.TimeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachestoreScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICachingScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IClassInitParam;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IEvictionPolicyClassScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IEvictionPolicyHybrid;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IEvictionPolicyLfu;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IEvictionPolicyLru;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IListener;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IUnitCalculatorBinary;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IUnitCalculatorClassScheme;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IUnitCalculatorFixed;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.OverrideValuesProvider;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.ParamTypeCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemeRefDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import oracle.eclipse.tools.coherence.descriptors.internal.TextAndElementBinding;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.DocumentationMergeStrategy;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

@Label(standard="local scheme")
public interface ILocalScheme
extends ICachingScheme,
IClassInitParam {
    public static final ElementType TYPE = new ElementType(ILocalScheme.class);
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.net.cache.LocalCache"})
    @Documentation(content="Specifies a custom implementation of the local cache. Any custom implementation must extend the com.tangosol.net.cache.LocalCache class and declare the exact same set of public constructors.")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, IClassInitParam.PROP_CLASS_NAME);
    @Documentation(content="Specifies initialization parameters, for use in custom local cache implementations which implement the com.tangosol.run.xml.XmlConfigurable interface.", mergeStrategy=DocumentationMergeStrategy.REPLACE)
    public static final ListProperty PROP_INIT_PARAMS = new ListProperty(TYPE, IClassInitParam.PROP_INIT_PARAMS);
    @XmlBinding(path="service-name")
    @Label(standard="service")
    @Service(impl=OverrideValuesProvider.class, params={@Service.Param(name="parentPath", value="cluster-config/services"), @Service.Param(name="attributePath", value="id"), @Service.Param(name="valuePath", value="service-type"), @Service.Param(name="severity", value="ok")})
    @Documentation(content="Specifies the name of the service which manages caches created from this scheme.")
    public static final ValueProperty PROP_SERVICE_NAME = new ValueProperty(TYPE, "ServiceName");
    @Type(base=IModelElementBase.class, possible={IEvictionPolicyLru.class, IEvictionPolicyLfu.class, IEvictionPolicyHybrid.class, IEvictionPolicyClassScheme.class})
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Label(standard="eviction policy")
    @XmlElementBinding(path="eviction-policy", mappings={@XmlElementBinding.Mapping(element="$$LRU", type=IEvictionPolicyLru.class), @XmlElementBinding.Mapping(element="$$LFU", type=IEvictionPolicyLfu.class), @XmlElementBinding.Mapping(element="$$HYBRID", type=IEvictionPolicyHybrid.class), @XmlElementBinding.Mapping(element="class-scheme", type=IEvictionPolicyClassScheme.class)})
    public static final ElementProperty PROP_EVICTION_POLICY = new ElementProperty(TYPE, "EvictionPolicy");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"high-units", "true"})
    @Label(standard="high units")
    @NumericRange(min="0")
    @DefaultValue(text="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=ILocalScheme]/HighUnits")})
    @Documentation(content="Used to limit the size of the cache. Contains the maximum number of units that can be placed in the cache before pruning occurs. An entry is the unit of measurement, unless it is overridden by an alternate unit-calculator (see <unit-calculator> subelement). When this limit is exceeded, the cache begins the pruning process, evicting entries according to the eviction policy. Zero implies no limit.")
    public static final ValueProperty PROP_HIGH_UNITS = new ValueProperty(TYPE, "HighUnits");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"high-units", "false"})
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=ILocalScheme]/HighUnitsUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="HighUnits")})})
    public static final ValueProperty PROP_HIGH_UNITS_UNIT = new ValueProperty(TYPE, "HighUnitsUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"high-units", "true", "true"})
    public static final ValueProperty PROP_HIGH_UNITS_PARAM = new ValueProperty(TYPE, "HighUnitsParam");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"low-units", "true"})
    @Label(standard="low units")
    @NumericRange(min="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=ILocalScheme]/LowUnits")})
    @Documentation(content="Contains the lowest number of units that a cache is pruned down to when pruning takes place. A pruning does not necessarily result in a cache containing this number of units, however a pruning never results in a cache containing less than this number of units. An entry is the unit of measurement, unless it is overridden by an alternate unit-calculator (see <unit-calculator> subelement). When pruning occurs entries continue to be evicted according to the eviction policy until this size. Zero implies the default. Default value is 75% of the high-units setting (that is, for a high-units setting of 1000 the default low-units is 750).")
    public static final ValueProperty PROP_LOW_UNITS = new ValueProperty(TYPE, "LowUnits");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"low-units", "false"})
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=ILocalScheme]/LowUnitsUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="LowUnits")})})
    public static final ValueProperty PROP_LOW_UNITS_UNIT = new ValueProperty(TYPE, "LowUnitsUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"low-units", "true", "true"})
    public static final ValueProperty PROP_LOW_UNITS_PARAM = new ValueProperty(TYPE, "LowUnitsParam");
    @Type(base=IModelElementBase.class, possible={IUnitCalculatorFixed.class, IUnitCalculatorBinary.class, IUnitCalculatorClassScheme.class})
    @CustomXmlElementBinding(impl=TextAndElementBinding.class)
    @Label(standard="unit calculator")
    @XmlElementBinding(path="unit-calculator", mappings={@XmlElementBinding.Mapping(element="$$fixed", type=IUnitCalculatorFixed.class), @XmlElementBinding.Mapping(element="$$binary", type=IUnitCalculatorBinary.class), @XmlElementBinding.Mapping(element="class-scheme", type=IUnitCalculatorClassScheme.class)})
    public static final ElementProperty PROP_UNIT_CALCULATOR = new ElementProperty(TYPE, "UnitCalculator");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"unit-factor"})
    @Label(standard="unit factor")
    @NumericRange(min="1")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=ILocalScheme]/UnitFactor")})
    @DefaultValue(text="1")
    @Documentation(content="Specifies the factor by which the units, low-units and high-units properties are adjusted. Using a BINARY unit calculator, for example, the factor of 1048576 could be used to count megabytes instead of bytes.")
    public static final ValueProperty PROP_UNIT_FACTOR = new ValueProperty(TYPE, "UnitFactor");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"unit-factor", "true"})
    public static final ValueProperty PROP_UNIT_FACTOR_PARAM = new ValueProperty(TYPE, "UnitFactorParam");
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"expiry-delay", "true"})
    @Label(standard="expiry delay")
    @DefaultValue(text="0")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=ILocalScheme]/ExpiryDelay")})
    @NumericRange(min="0")
    @Documentation(content="Specifies the amount of time since the last update that entries are kept by the cache before being expired. Entries that have expired are not be accessible and are evicted the next time a client accesses the cache. Any attempt to read an expired entry results in a reloading of the entry from the configured cache store.[pbr/]If the value does not contain a unit, a unit of seconds is assumed. A value of zero implies no expiry.")
    public static final ValueProperty PROP_EXPIRY_DELAY = new ValueProperty(TYPE, "ExpiryDelay");
    @Type(base=TimeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"expiry-delay", "false"})
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=ILocalScheme]/ExpiryDelayUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="ExpiryDelay")})})
    @DefaultValue(text="s")
    public static final ValueProperty PROP_EXPIRY_DELAY_UNIT = new ValueProperty(TYPE, "ExpiryDelayUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"expiry-delay", "true", "true"})
    public static final ValueProperty PROP_EXPIRY_DELAY_PARAM = new ValueProperty(TYPE, "ExpiryDelayParam");
    @Type(base=ICachestoreScheme.class)
    @XmlBinding(path="cachestore-scheme")
    public static final ImpliedElementProperty PROP_CACHE_STORE_SCHEME = new ImpliedElementProperty(TYPE, "CachestoreScheme");
    @Type(base=Boolean.class)
    @XmlBinding(path="pre-load")
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"pre-load"})
    @Label(standard="pre load")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="dependsOn", value="/CachingSchemes[#type=ILocalScheme]/PreLoad")})
    @DefaultValue(text="false")
    @Documentation(content="Specifies whether a cache will pre-load data from its CacheLoader (or CacheStore) object.")
    public static final ValueProperty PROP_PRE_LOAD = new ValueProperty(TYPE, "PreLoad");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"pre-load", "true"})
    public static final ValueProperty PROP_PRE_LOAD_PARAM = new ValueProperty(TYPE, "PreLoadParam");
    @Type(base=IListener.class)
    @XmlBinding(path="listener/class-scheme")
    public static final ImpliedElementProperty PROP_LISTENER = new ImpliedElementProperty(TYPE, "Listener");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"scope-name"})
    @Label(standard="scope")
    @Since(value="12.1.2")
    @Documentation(content="The scope-name element contains the scope name for this configuration. The scope name is typically added to the service name (as a prefix) for all services generated by a cache factory.  Scope may be used to isolate services indicated in this cache configuration from services created by cache factories with other configurations, thus avoiding unintended joining of services with similar names from different configurations.")
    public static final ValueProperty PROP_SCOPE_NAME = new ValueProperty(TYPE, "ScopeName");
    @CustomXmlValueBinding(impl=ParamTypeCustomBinding.class, params={"scope-name", "true"})
    public static final ValueProperty PROP_SCOPE_NAME_PARAM = new ValueProperty(TYPE, "ScopeNameParam");

    public Value<String> getServiceName();

    public void setServiceName(String var1);

    public ElementHandle<IModelElementBase> getEvictionPolicy();

    public Value<Integer> getHighUnits();

    public void setHighUnits(String var1);

    public void setHighUnits(Integer var1);

    public Value<SizeUnit> getHighUnitsUnit();

    public void setHighUnitsUnit(String var1);

    public void setHighUnitsUnit(SizeUnit var1);

    public Value<String> getHighUnitsParam();

    public void setHighUnitsParam(String var1);

    public Value<Integer> getLowUnits();

    public void setLowUnits(String var1);

    public void setLowUnits(Integer var1);

    public Value<SizeUnit> getLowUnitsUnit();

    public void setLowUnitsUnit(String var1);

    public void setLowUnitsUnit(SizeUnit var1);

    public Value<String> getLowUnitsParam();

    public void setLowUnitsParam(String var1);

    public ElementHandle<IModelElementBase> getUnitCalculator();

    public Value<Integer> getUnitFactor();

    public void setUnitFactor(String var1);

    public void setUnitFactor(Integer var1);

    public Value<String> getUnitFactorParam();

    public void setUnitFactorParam(String var1);

    public Value<BigDecimal> getExpiryDelay();

    public void setExpiryDelay(String var1);

    public void setExpiryDelay(BigDecimal var1);

    public Value<TimeUnit> getExpiryDelayUnit();

    public void setExpiryDelayUnit(String var1);

    public void setExpiryDelayUnit(TimeUnit var1);

    public Value<String> getExpiryDelayParam();

    public void setExpiryDelayParam(String var1);

    public ICachestoreScheme getCachestoreScheme();

    public Value<Boolean> getPreLoad();

    public void setPreLoad(String var1);

    public void setPreLoad(Boolean var1);

    public Value<String> getPreLoadParam();

    public void setPreLoadParam(String var1);

    public IListener getListener();

    public Value<String> getScopeName();

    public void setScopeName(String var1);

    public Value<String> getScopeNameParam();

    public void setScopeNameParam(String var1);
}

