/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import oracle.eclipse.tools.coherence.descriptors.BackupStorageType;
import oracle.eclipse.tools.coherence.descriptors.SizeUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.BackupStorageCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.SchemeRefDefaultValueProvider;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IBackupStorage
extends Element {
    public static final ElementType TYPE = new ElementType(IBackupStorage.class);
    @Type(base=BackupStorageType.class)
    @CustomXmlValueBinding(impl=BackupStorageCustomBinding.class)
    @Label(standard="type")
    @DefaultValue(text="on-heap")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(7)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/Type")})
    @Documentation(content="Specifies the type of the storage used to hold the backup data.[pbr/]Legal values are: [ul][li]on-heap: The corresponding implementations class is java.util.HashMap.[/li][li]off-heap: The corresponding implementations class is com.tangosol.util.nio.BinaryMap using com.tangosol.util.nio.DirectBufferManager. Only available with JDK 1.4 and later.[/li][li]file-mapped: The corresponding implementations class is com.tangosol.util.nio.BinaryMap using com.tangosol.util.nio.MappedBufferManager. Only available with JDK 1.4 and later.[/li][li]custom: The corresponding implementations class is the class specified by the backup-storage/class element.[/li][li]scheme: The corresponding implementations class is the map returned by the ConfigurableCacheFactory for the scheme referred to by the backup-storage/scheme-name element.[/li][/ul]")
    public static final ValueProperty PROP_TYPE = new ValueProperty(TYPE, "Type");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"backup-storage/initial-size", "true"})
    @Label(standard="initial size")
    @DefaultValue(text="1")
    @NumericRange(min="1")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(,backup-storage/initial-size)/param-value"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/InitialSize")})
    @Enablement(expr="${ Type IN List ('off-heap', 'file-mapped') }")
    @Documentation(content="Only applicable with the off-heap and file-mapped types.[pbr/]Specifies the initial buffer size in bytes.")
    public static final ValueProperty PROP_INITIAL_SIZE = new ValueProperty(TYPE, "InitialSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"backup-storage/initial-size", "false"})
    @DefaultValue(text="MB")
    @Enablement(expr="${ Type IN List ('off-heap', 'file-mapped') }")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(,backup-storage/initial-size)/param-value"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/InitialSizeUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="InitialSize")})})
    public static final ValueProperty PROP_INITIAL_SIZE_UNIT = new ValueProperty(TYPE, "InitialSizeUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"backup-storage/initial-size", "true", "true"})
    public static final ValueProperty PROP_INITIAL_SIZE_PARAM = new ValueProperty(TYPE, "InitialSizeParam");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"backup-storage/maximum-size", "true"})
    @Label(standard="maximum size")
    @DefaultValue(text="1024")
    @NumericRange(min="1")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(,backup-storage/maximum-size)/param-value"), @Service.Param(name="default", value="true"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/MaximumSize")})
    @Enablement(expr="${ Type IN List ('off-heap', 'file-mapped') }")
    @Documentation(content="Only applicable with the off-heap and file-mapped types.[pbr/]Specifies the maximum buffer size in bytes.")
    public static final ValueProperty PROP_MAXIMUM_SIZE = new ValueProperty(TYPE, "MaximumSize");
    @Type(base=SizeUnit.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"backup-storage/maximum-size", "false"})
    @DefaultValue(text="MB")
    @Enablement(expr="${ Type IN List ('off-heap', 'file-mapped') }")
    @Services(value={@Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(,backup-storage/maximum-size)/param-value"), @Service.Param(name="default", value="false"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/MaximumSizeUnit")}), @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="MaximumSize")})})
    public static final ValueProperty PROP_MAXIMUM_SIZE_UNIT = new ValueProperty(TYPE, "MaximumSizeUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"backup-storage/maximum-size", "true", "true"})
    public static final ValueProperty PROP_MAXIMUM_SIZE_PARAM = new ValueProperty(TYPE, "MaximumSizeParam");
    @Type(base=Path.class)
    @XmlBinding(path="backup-storage/directory")
    @Label(standard="directory")
    @Enablement(expr="${ Type == 'file-mapped' }")
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    @AbsolutePath
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(,backup-storage/directory)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/Directory")})
    @Documentation(content="Only applicable with the file-mapped type.[pbr/]Specifies the pathname for the directory that the disk persistence manager (com.tangosol.util.nio.MappedBufferManager) will use as \"root\" to store files in. If not specified or specifies a non-existent directory, a temporary file in the default location is used.[pbr/]Default value is the default temporary directory designated by the Java runtime.")
    public static final ValueProperty PROP_DIRECTORY = new ValueProperty(TYPE, "Directory");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @XmlBinding(path="backup-storage/class-name")
    @Label(standard="class")
    @Enablement(expr="${ Type == 'custom' }")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.run.xml.XmlConfigurable"})
    @MustExist
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(,backup-storage/class-name)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/ClassName")})
    @Documentation(content="Only applicable with the custom type.[pbr/]Specifies a class name for the custom storage implementation. If the class implements com.tangosol.run.xml.XmlConfigurable interface then upon construction the setConfig method is called passing the entire backup-storage element.")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, "ClassName");
    @Label(standard="scheme")
    @XmlBinding(path="backup-storage/scheme-name")
    @Enablement(expr="${ Type == 'scheme' }")
    @Service(impl=SchemeRefDefaultValueProvider.class, params={@Service.Param(name="path", value="cluster-config/services/service(3)/init-params/init-param(,backup-storage/scheme-name)/param-value"), @Service.Param(name="dependsOn", value="/CachingSchemes[#type=IDistributedScheme]/BackupStorageSchemeName")})
    @Documentation(content="Only applicable with the scheme type.[pbr/]Specifies a scheme name for the ConfigurableCacheFactory.")
    public static final ValueProperty PROP_BACKUP_STORAGE_SCHEME_NAME = new ValueProperty(TYPE, "BackupStorageSchemeName");

    public Value<BackupStorageType> getType();

    public void setType(String var1);

    public void setType(BackupStorageType var1);

    public Value<Integer> getInitialSize();

    public void setInitialSize(String var1);

    public void setInitialSize(Integer var1);

    public Value<SizeUnit> getInitialSizeUnit();

    public void setInitialSizeUnit(String var1);

    public void setInitialSizeUnit(SizeUnit var1);

    public Value<String> getInitialSizeParam();

    public void setInitialSizeParam(String var1);

    public Value<Integer> getMaximumSize();

    public void setMaximumSize(String var1);

    public void setMaximumSize(Integer var1);

    public Value<SizeUnit> getMaximumSizeUnit();

    public void setMaximumSizeUnit(String var1);

    public void setMaximumSizeUnit(SizeUnit var1);

    public Value<String> getMaximumSizeParam();

    public void setMaximumSizeParam(String var1);

    public Value<Path> getDirectory();

    public void setDirectory(String var1);

    public void setDirectory(Path var1);

    public ReferenceValue<JavaTypeName, JavaType> getClassName();

    public void setClassName(String var1);

    public void setClassName(JavaTypeName var1);

    public Value<String> getBackupStorageSchemeName();

    public void setBackupStorageSchemeName(String var1);
}

