/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.cacheConfig;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.SizeKMUnit;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IBdbFileManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ICustomStoreManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.ILhFileManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.INioFileManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.INioMemoryManager;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.IStoreManagerBase;
import oracle.eclipse.tools.coherence.descriptors.cacheConfig.internal.NumberWithUnitPropertyCustomBinding;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberUnitEnabler;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;

public interface IAsyncStoreManager
extends IStoreManagerBase {
    public static final ElementType TYPE = new ElementType(IAsyncStoreManager.class);
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"com.tangosol.io.AsyncBinaryStoreManager"})
    @Documentation(content="Specifies a custom implementation of the async-store-manager. Any custom implementation must extend the com.tangosol.io.AsyncBinaryStoreManager class and declare the exact same set of public constructors.")
    public static final ValueProperty PROP_CLASS_NAME = new ValueProperty(TYPE, IStoreManagerBase.PROP_CLASS_NAME);
    @Type(base=IStoreManagerBase.class, possible={IBdbFileManager.class, ICustomStoreManager.class, ILhFileManager.class, INioFileManager.class, INioMemoryManager.class})
    @XmlElementBinding(path="", mappings={@XmlElementBinding.Mapping(element="bdb-store-manager", type=IBdbFileManager.class), @XmlElementBinding.Mapping(element="custom-store-manager", type=ICustomStoreManager.class), @XmlElementBinding.Mapping(element="lh-file-manager", type=ILhFileManager.class), @XmlElementBinding.Mapping(element="nio-file-manager", type=INioFileManager.class), @XmlElementBinding.Mapping(element="nio-memory-manager", type=INioMemoryManager.class)})
    @Label(standard="binary store manager")
    @Required
    public static final ElementProperty PROP_STORE_MANAGER = new ElementProperty(TYPE, "StoreManager");
    @Label(standard="async limit")
    @Type(base=BigDecimal.class)
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"async-limit", "true"})
    @DefaultValue(text="4")
    @Documentation(content="specifies the maximum number of bytes that will be queued to be written asynchronously.")
    public static final ValueProperty PROP_ASYNC_LIMIT = new ValueProperty(TYPE, "AsyncLimit");
    @Type(base=SizeKMUnit.class)
    @DefaultValue(text="MB")
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"async-limit", "false"})
    @Service(impl=NumberUnitEnabler.class, params={@Service.Param(name="property", value="AsyncLimit")})
    public static final ValueProperty PROP_ASYNC_LIMIT_UNIT = new ValueProperty(TYPE, "AsyncLimitUnit");
    @CustomXmlValueBinding(impl=NumberWithUnitPropertyCustomBinding.class, params={"async-limit", "true", "true"})
    public static final ValueProperty PROP_ASYNC_LIMIT_PARAM = new ValueProperty(TYPE, "AsyncLimitParam");

    public ElementHandle<IStoreManagerBase> getStoreManager();

    public Value<BigDecimal> getAsyncLimit();

    public void setAsyncLimit(String var1);

    public void setAsyncLimit(BigDecimal var1);

    public Value<SizeKMUnit> getAsyncLimitUnit();

    public void setAsyncLimitUnit(String var1);

    public void setAsyncLimitUnit(SizeKMUnit var1);

    public Value<String> getAsyncLimitParam();

    public void setAsyncLimitParam(String var1);
}

