/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors;

import oracle.eclipse.tools.coherence.CoherenceVersion;
import org.eclipse.sapphire.Version;

public class PofConfigInfo {
    public static final String ELEMENT_NAME = "pof-config";
    public static final String NAME_SPACE = "http://xmlns.oracle.com/coherence/coherence-pof-config";
    private static final String SCHEMA_LOCATION_3_7 = "http://xmlns.oracle.com/coherence/coherence-pof-config/1.0/coherence-pof-config.xsd";
    private static final String SCHEMA_LOCATION_3_7_1 = "http://xmlns.oracle.com/coherence/coherence-pof-config/1.1/coherence-pof-config.xsd";
    private static final String SCHEMA_LOCATION_12_1_2 = "http://xmlns.oracle.com/coherence/coherence-pof-config/1.2/coherence-pof-config.xsd";
    private static final String SYSTEM_ID = "pof-config.dtd";
    private static final PofConfigInfo INFO = new PofConfigInfo(null, null, "pof-config", "pof-config.dtd");
    private static final PofConfigInfo INFO_3_7 = new PofConfigInfo("http://xmlns.oracle.com/coherence/coherence-pof-config", "http://xmlns.oracle.com/coherence/coherence-pof-config/1.0/coherence-pof-config.xsd", "pof-config", null);
    private static final PofConfigInfo INFO_3_7_1 = new PofConfigInfo("http://xmlns.oracle.com/coherence/coherence-pof-config", "http://xmlns.oracle.com/coherence/coherence-pof-config/1.1/coherence-pof-config.xsd", "pof-config", null);
    private static final PofConfigInfo INFO_12_1_2 = new PofConfigInfo("http://xmlns.oracle.com/coherence/coherence-pof-config", "http://xmlns.oracle.com/coherence/coherence-pof-config/1.2/coherence-pof-config.xsd", "pof-config", null);
    private final String namespace;
    private final String schemaLocation;
    private final String rootElementName;
    private final String systemId;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String POF_CONFIG_HEADER_XML = "<?xml version=\"1.0\"?>" + NEW_LINE + "<!DOCTYPE pof-config SYSTEM \"pof-config.dtd\">" + NEW_LINE + "<pof-config>";
    private static final String POF_CONFIG_HEADER_XML_BEGIN = "<?xml version=\"1.0\"?>" + NEW_LINE + "<pof-config xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + NEW_LINE + "    xmlns=\"http://xmlns.oracle.com/coherence/coherence-pof-config\"" + NEW_LINE + "    xsi:schemaLocation=\"http://xmlns.oracle.com/coherence/coherence-pof-config ";
    private static final String POF_CONFIG_HEADER_XML_END = "\">";
    private static final String POF_CONFIG_CONTENT_XML = String.valueOf(NEW_LINE) + "\t<user-type-list>" + NEW_LINE + "\t<!-- include all \"standard\" Coherence POF user types -->" + NEW_LINE + "\t<include>coherence-pof-config.xml</include>" + NEW_LINE + NEW_LINE + "\t</user-type-list>" + NEW_LINE + "</pof-config>";

    public PofConfigInfo(String namespace, String schemaLocation, String rootElementName, String systemId) {
        this.namespace = namespace;
        this.schemaLocation = schemaLocation;
        this.rootElementName = rootElementName;
        this.systemId = systemId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public static String getHeader(Version version) {
        if (version.equals((Object)CoherenceVersion.VERSION_3_7)) {
            return String.valueOf(POF_CONFIG_HEADER_XML_BEGIN) + SCHEMA_LOCATION_3_7 + POF_CONFIG_HEADER_XML_END;
        }
        if (version.equals((Object)CoherenceVersion.VERSION_3_7_1)) {
            return String.valueOf(POF_CONFIG_HEADER_XML_BEGIN) + SCHEMA_LOCATION_3_7_1 + POF_CONFIG_HEADER_XML_END;
        }
        if (version.equals((Object)CoherenceVersion.VERSION_12_1_2)) {
            return String.valueOf(POF_CONFIG_HEADER_XML_BEGIN) + SCHEMA_LOCATION_12_1_2 + POF_CONFIG_HEADER_XML_END;
        }
        return POF_CONFIG_HEADER_XML;
    }

    public static String getContent(Version version) {
        return String.valueOf(PofConfigInfo.getHeader(version)) + POF_CONFIG_CONTENT_XML;
    }

    public static PofConfigInfo getCacheConfigInfo(Version version) {
        if (version.equals((Object)CoherenceVersion.VERSION_3_7)) {
            return INFO_3_7;
        }
        if (version.equals((Object)CoherenceVersion.VERSION_3_7_1)) {
            return INFO_3_7_1;
        }
        if (version == CoherenceVersion.VERSION_12_1_2) {
            return INFO_12_1_2;
        }
        return INFO;
    }
}

