/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors;

import java.io.File;
import oracle.eclipse.tools.coherence.descriptors.application.ICoherenceApplication;
import oracle.eclipse.tools.coherence.internal.CoherencePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.FileResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;

public final class CoherenceDescriptorsFactory {
    public static ICoherenceApplication getCoherenceApplication(IProject project) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc == null) {
            return null;
        }
        IVirtualFile vf = vc.getRootFolder().getFile("META-INF/coherence-application.xml");
        return CoherenceDescriptorsFactory.getCoherenceApplication(vf.getUnderlyingFile());
    }

    public static ICoherenceApplication getCoherenceApplication(IFile file) {
        try {
            return CoherenceDescriptorsFactory.getCoherenceApplication(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            CoherencePlugin.log((Exception)((Object)e));
            return null;
        }
    }

    public static ICoherenceApplication getCoherenceApplication(File file) {
        try {
            return CoherenceDescriptorsFactory.getCoherenceApplication(new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            CoherencePlugin.log((Exception)((Object)e));
            return null;
        }
    }

    public static ICoherenceApplication getCoherenceApplication(XmlResourceStore xmlResourceStore) {
        return (ICoherenceApplication)ICoherenceApplication.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
    }
}

