/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence;

import oracle.eclipse.tools.coherence.facets.CoherenceFacet;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Version;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class CoherenceVersion {
    public static final Version VERSION_3_5 = new Version("3.5");
    public static final Version VERSION_3_6 = new Version("3.6");
    public static final Version VERSION_3_7 = new Version("3.7");
    public static final Version VERSION_3_7_1 = new Version("3.7.1");
    public static final Version VERSION_12_1_2;
    public static final Version VERSION_NEWEST;

    static {
        VERSION_NEWEST = VERSION_12_1_2 = new Version("12.1.2");
    }

    public static Version detect(IProject project) {
        IProjectFacetVersion version = CoherenceFacet.getProjectFacet(project);
        if (version.equals(CoherenceFacet.VERSION_3_5)) {
            return VERSION_3_5;
        }
        if (version.equals(CoherenceFacet.VERSION_3_6)) {
            return VERSION_3_6;
        }
        if (version.equals(CoherenceFacet.VERSION_3_7)) {
            return VERSION_3_7;
        }
        if (version.equals(CoherenceFacet.VERSION_3_7_1)) {
            return VERSION_3_7_1;
        }
        if (version.equals(CoherenceFacet.VERSION_12_1_2)) {
            return VERSION_12_1_2;
        }
        return null;
    }

    public static Version major(Version version) {
        if (version != null) {
            if (version.matches("[3.5-3.6)")) {
                return VERSION_3_5;
            }
            if (version.matches("[3.6-3.7)")) {
                return VERSION_3_6;
            }
            if (version.matches("[3.7-3.7.1)")) {
                return VERSION_3_7;
            }
            if (version.matches("[3.7.1-3.7.2)")) {
                return VERSION_3_7_1;
            }
            if (version.matches("[12.1.2-12.1.3)")) {
                return VERSION_12_1_2;
            }
        }
        return null;
    }
}

