/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.override.internal;

import oracle.eclipse.tools.coherence.descriptors.override.IClusterConfig;
import oracle.eclipse.tools.coherence.descriptors.override.IClusterSocketProvider;
import oracle.eclipse.tools.coherence.descriptors.override.ICoherenceOverride;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ISocketProviderUnicastName;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.JumpActionHandler;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPagePart;

public class SocketProviderJumpHandler
extends JumpActionHandler {
    private static final String SOCKET_PROVIDERS_PATH = "Cluster/Socket Providers/";

    protected boolean computeEnablementState() {
        ISocketProviderUnicastName element;
        String name;
        if (super.computeEnablementState() && this.getModelElement() instanceof ISocketProviderUnicastName && (name = (element = (ISocketProviderUnicastName)this.getModelElement()).getName().text()) != null) {
            ICoherenceOverride override = (ICoherenceOverride)element.nearest(ICoherenceOverride.class);
            IClusterConfig clusterConfig = override.getClusterConfig();
            for (IClusterSocketProvider provider : clusterConfig.getSocketProviders()) {
                String id = provider.getId().text();
                if (!name.equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    protected Object run(Presentation context) {
        ISocketProviderUnicastName providerName = (ISocketProviderUnicastName)this.getModelElement();
        String name = providerName.getName().text();
        if (name != null) {
            String nodePath = SOCKET_PROVIDERS_PATH + name;
            MasterDetailsEditorPagePart page = (MasterDetailsEditorPagePart)this.getPart().nearest(MasterDetailsEditorPagePart.class);
            page.outline().setSelection(nodePath);
        }
        return null;
    }
}

