/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.override.internal;

import oracle.eclipse.tools.coherence.descriptors.IInstanceBase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.JumpActionHandler;

public class MethodNameJumpHandler
extends JumpActionHandler {
    protected boolean computeEnablementState() {
        IMethod method;
        return super.computeEnablementState() && (method = this.getMethod()) != null;
    }

    protected Object run(Presentation context) {
        try {
            IMethod method = this.getMethod();
            if (method != null) {
                JavaUI.openInEditor((IJavaElement)method);
            }
        }
        catch (CoreException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return null;
    }

    private IMethod getMethod() {
        try {
            IType type;
            String typeName;
            Value property = (Value)this.property();
            String methodName = property.text(true);
            if (methodName != null && methodName.length() > 0 && (typeName = this.getClassName()) != null && (type = MethodNameJumpHandler.getType(typeName, (IProject)property.element().adapt(IProject.class))) != null) {
                IMethod[] iMethodArray = type.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    if (methodName.equals(method.getElementName())) {
                        return method;
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private String getClassName() {
        String className = null;
        Element elem = this.property().element();
        if (elem instanceof IInstanceBase) {
            className = ((IInstanceBase)elem).getClassFactoryName().text(false);
        }
        return className;
    }

    private static IType getType(String fullyQualifiedType, IProject project) {
        assert (fullyQualifiedType != null) : "Fully qualified type should not be null.";
        if (fullyQualifiedType.trim().length() == 0 || fullyQualifiedType.startsWith(".") || fullyQualifiedType.endsWith(".")) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        String name = fullyQualifiedType.replace('$', '.');
        IType type = null;
        try {
            type = javaProject.findType(name);
            if (type != null && (!type.exists() || type.isAnonymous())) {
                type = null;
            }
        }
        catch (JavaModelException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return type;
    }
}

