/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.override.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import oracle.eclipse.tools.coherence.descriptors.override.ILoggingConfig;
import oracle.eclipse.tools.coherence.ui.internal.CoherenceUiPlugin;
import oracle.eclipse.tools.common.util.ObjectUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;

public class MessageFormatBrowseHandler
extends BrowseActionHandler {
    public String browse(Presentation context) {
        MessageFormatTemplatePreferencePage page = new MessageFormatTemplatePreferencePage();
        ILoggingConfig logging = (ILoggingConfig)this.getModelElement().nearest(ILoggingConfig.class);
        String format = logging.getMessageFormat().text();
        String title = this.property().definition().getLabel(false, CapitalizationType.TITLE_STYLE, false);
        String newFormat = page.editTemplate(((SwtPresentation)context).shell(), title, format);
        if (ObjectUtil.equal((Object)format, (Object)newFormat)) {
            return null;
        }
        return newFormat;
    }

    private static class Date
    extends SimpleTemplateVariableResolver {
        public Date() {
            super("date", Resources.date_description);
        }
    }

    private static class Level
    extends SimpleTemplateVariableResolver {
        public Level() {
            super("level", Resources.level_description);
        }
    }

    private static class Location
    extends SimpleTemplateVariableResolver {
        public Location() {
            super("location", Resources.location_description);
        }
    }

    private static class Member
    extends SimpleTemplateVariableResolver {
        public Member() {
            super("member", Resources.member_description);
        }
    }

    private static final class MessageFormatTemplateContentType
    extends TemplateContextType {
        public MessageFormatTemplateContentType(String name) {
            super(name);
            this.addResolver((TemplateVariableResolver)new Date());
            this.addResolver((TemplateVariableResolver)new Version());
            this.addResolver((TemplateVariableResolver)new Level());
            this.addResolver((TemplateVariableResolver)new Thread());
            this.addResolver((TemplateVariableResolver)new Member());
            this.addResolver((TemplateVariableResolver)new Location());
            this.addResolver((TemplateVariableResolver)new Role());
            this.addResolver((TemplateVariableResolver)new Text());
        }
    }

    private static class MessageFormatTemplatePreferencePage
    extends TemplatePreferencePage {
        private static final String MESSAGE_FORMAT_CONTEXT = "message-format-context";

        public String editTemplate(Shell shell, String title, String pattern) {
            Template template = new Template(Resources.message_format, Resources.message_format_description, MESSAGE_FORMAT_CONTEXT, pattern, true);
            boolean edit = true;
            boolean isNameModifiable = false;
            ContextTypeRegistry registry = new ContextTypeRegistry();
            registry.addContextType((TemplateContextType)new MessageFormatTemplateContentType(MESSAGE_FORMAT_CONTEXT));
            MessageFormatEditTemplateDialog dialog = new MessageFormatEditTemplateDialog(shell, title, template, edit, isNameModifiable, registry);
            if (dialog.open() == 0) {
                Template mod = dialog.getTemplate();
                return mod.getPattern();
            }
            return null;
        }

        class MessageFormatEditTemplateDialog
        extends TemplatePreferencePage.EditTemplateDialog {
            private final MessageFormatTemplateVariableProcessor fMessageFormatTemplateProcessor;

            public MessageFormatEditTemplateDialog(Shell parent, String title, Template template, boolean edit, boolean isNameModifiable, ContextTypeRegistry registry) {
                super(parent, template, edit, isNameModifiable, registry);
                this.fMessageFormatTemplateProcessor = new MessageFormatTemplateVariableProcessor();
                this.setTitle(title);
                TemplateContextType type = registry.getContextType(template.getContextTypeId());
                this.fMessageFormatTemplateProcessor.setContextType(type);
            }

            protected SourceViewer createViewer(Composite parent) {
                SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
                SourceViewerConfiguration configuration = new SourceViewerConfiguration(){

                    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                        ContentAssistant assistant = new ContentAssistant();
                        assistant.enableAutoActivation(true);
                        assistant.enableAutoInsert(true);
                        assistant.setContentAssistProcessor((IContentAssistProcessor)MessageFormatEditTemplateDialog.this.fMessageFormatTemplateProcessor, "__dftl_partition_content_type");
                        return assistant;
                    }
                };
                viewer.configure(configuration);
                return viewer;
            }

            protected IContentAssistProcessor getTemplateProcessor() {
                return this.fMessageFormatTemplateProcessor;
            }
        }
    }

    public static class MessageFormatTemplateVariableProcessor
    implements IContentAssistProcessor {
        private static Comparator fgTemplateVariableProposalComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                MessageFormatTemplateVariableProposal proposal0 = (MessageFormatTemplateVariableProposal)arg0;
                MessageFormatTemplateVariableProposal proposal1 = (MessageFormatTemplateVariableProposal)arg1;
                return proposal0.getDisplayString().compareTo(proposal1.getDisplayString());
            }
        };
        private TemplateContextType fContextType;

        public void setContextType(TemplateContextType contextType) {
            this.fContextType = contextType;
        }

        public TemplateContextType getContextType() {
            return this.fContextType;
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
            if (this.fContextType == null) {
                return null;
            }
            ArrayList<MessageFormatTemplateVariableProposal> proposals = new ArrayList<MessageFormatTemplateVariableProposal>();
            String text = viewer.getDocument().get();
            int start = this.getStart(text, documentOffset);
            int end = documentOffset;
            String string = text.substring(start, end);
            int colon = string.indexOf(58);
            boolean includeBrace = true;
            int offset = start;
            String prefix = string;
            if (colon != -1) {
                includeBrace = false;
                offset = start + colon + 1;
                prefix = string.substring(colon + 1);
            } else {
                int escape = string.indexOf("{");
                if (escape != -1) {
                    offset = start + escape + 1;
                    includeBrace = false;
                    prefix = string.substring(escape + 1);
                }
            }
            if (prefix.equals("{")) {
                prefix = "";
            }
            int length = end - offset;
            Iterator iterator = this.fContextType.resolvers();
            while (iterator.hasNext()) {
                TemplateVariableResolver variable = (TemplateVariableResolver)iterator.next();
                if (!variable.getType().startsWith(prefix)) continue;
                proposals.add(new MessageFormatTemplateVariableProposal(variable, offset, length, viewer, includeBrace));
            }
            Collections.sort(proposals, fgTemplateVariableProposalComparator);
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        /*
         * Unable to fully structure code
         */
        private int getStart(String string, int end) {
            start = end;
            if (start < 1 || string.charAt(start - 1) != '{') ** GOTO lbl5
            return start - 1;
lbl-1000:
            // 1 sources

            {
                --start;
lbl5:
                // 2 sources

                ** while (start != 0 && Character.isUnicodeIdentifierPart((char)string.charAt((int)(start - 1))))
            }
lbl6:
            // 1 sources

            if (start >= 1 && string.charAt(start - 1) == ':') {
                --start;
                while (start != 0 && Character.isUnicodeIdentifierPart(string.charAt(start - 1))) {
                    --start;
                }
            }
            return end;
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return new char[]{'{'};
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return null;
        }

        public String getErrorMessage() {
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }
    }

    public static class MessageFormatTemplateVariableProposal
    implements ICompletionProposal {
        private TemplateVariableResolver fResolver;
        private int fOffset;
        private int fLength;
        private ITextViewer fViewer;
        private Point fSelection;
        private final boolean fIncludeBrace;

        public MessageFormatTemplateVariableProposal(TemplateVariableResolver variable, int offset, int length, ITextViewer viewer, boolean includeBrace) {
            this.fResolver = variable;
            this.fOffset = offset;
            this.fLength = length;
            this.fViewer = viewer;
            this.fIncludeBrace = includeBrace;
        }

        public void apply(IDocument document) {
            try {
                String type = this.fResolver.getType();
                String variable = type.equals("dollar") ? "$$" : (this.fIncludeBrace ? "{" + type + '}' : type);
                document.replace(this.fOffset, this.fLength, variable);
                this.fSelection = new Point(this.fOffset + variable.length(), 0);
            }
            catch (BadLocationException e) {
                CoherenceUiPlugin.log((Exception)((Object)e));
                Shell shell = this.fViewer.getTextWidget().getShell();
                MessageDialog.openError((Shell)shell, (String)Resources.error_title, (String)e.getMessage());
            }
        }

        public Point getSelection(IDocument document) {
            return this.fSelection;
        }

        public String getAdditionalProposalInfo() {
            return this.fResolver.getDescription();
        }

        public String getDisplayString() {
            return String.valueOf(this.fResolver.getType()) + " - " + this.fResolver.getDescription();
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String toString() {
            return this.getDisplayString();
        }
    }

    private static final class Resources
    extends NLS {
        public static String message_format;
        public static String message_format_description;
        public static String error_title;
        public static String date_description;
        public static String version_description;
        public static String level_description;
        public static String thread_description;
        public static String member_description;
        public static String location_description;
        public static String role_description;
        public static String text_description;

        static {
            Resources.initializeMessages((String)MessageFormatBrowseHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static class Role
    extends SimpleTemplateVariableResolver {
        public Role() {
            super("role", Resources.role_description);
        }
    }

    private static class Text
    extends SimpleTemplateVariableResolver {
        public Text() {
            super("text", Resources.text_description);
        }
    }

    private static class Thread
    extends SimpleTemplateVariableResolver {
        public Thread() {
            super("thread", Resources.thread_description);
        }
    }

    private static class Version
    extends SimpleTemplateVariableResolver {
        public Version() {
            super("version", Resources.version_description);
        }
    }
}

