/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.launchConfig.internal;

import java.io.File;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.CoherenceModel;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.ILaunchConfig;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigResource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.swt.RelativePathBrowseActionHandler;

public class WorkingDirPathValueBrowseHandler
extends RelativePathBrowseActionHandler {
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setLabel(Resources.label);
    }

    protected List<Path> getBasePaths() {
        ILaunchConfig config = (ILaunchConfig)this.getModelElement().nearest(ILaunchConfig.class);
        CoherenceModel model = ((LaunchConfigResource)config.resource()).getCoherenceModel();
        File workingDir = model.getWorkingDir();
        if (workingDir != null) {
            IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(workingDir.toURI());
            if (containers != null && containers.length > 0) {
                return Collections.singletonList(PathBridge.create((IPath)containers[0].getLocation()));
            }
            return Collections.singletonList(PathBridge.create((IPath)ResourcesPlugin.getWorkspace().getRoot().getLocation()));
        }
        return Collections.emptyList();
    }

    private static final class Resources
    extends NLS {
        public static String label;

        static {
            Resources.initializeMessages((String)WorkingDirPathValueBrowseHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

