/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.launchConfig.internal;

import java.util.ArrayList;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.CoherenceModel;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.ILaunchConfig;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;

public class SystemPropertiesResetContributor
extends PropertyEditorAssistContributor {
    public void contribute(PropertyEditorAssistContext context) {
        Element element = context.getPart().getLocalModelElement();
        final ILaunchConfig launchConfig = (ILaunchConfig)element.nearest(ILaunchConfig.class);
        final CoherenceModel coherenceModel = ((LaunchConfigResource)launchConfig.resource()).getCoherenceModel();
        final ArrayList<String> list = new ArrayList<String>();
        for (String key : coherenceModel.getSystemProperties()) {
            if (coherenceModel.getValue(key) == null) continue;
            list.add(key);
        }
        if (!list.isEmpty()) {
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            contribution.text("<p><a href=\"action\" nowrap=\"true\">" + Resources.restoreDefaultValue + "</a></p>");
            contribution.link("action", new Runnable(){

                @Override
                public void run() {
                    for (String key : list) {
                        coherenceModel.setValue(key, null);
                    }
                    launchConfig.refresh();
                    coherenceModel.propertyChanged();
                }
            });
            PropertyEditorAssistSection section = context.getSection("actions");
            section.addContribution(contribution.create());
        }
    }

    private static final class Resources
    extends NLS {
        public static String restoreDefaultValue;

        static {
            Resources.initializeMessages((String)SystemPropertiesResetContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

