/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.launchConfig.internal;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.CoherenceModel;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.ILaunchConfig;
import oracle.eclipse.tools.coherence.descriptors.launchConfig.internal.LaunchConfigResource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.swt.RelativePathBrowseActionHandler;

public class SourcePathValueBrowseHandler
extends RelativePathBrowseActionHandler {
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setLabel(Resources.label);
    }

    protected List<Path> getBasePaths() {
        ILaunchConfig config = (ILaunchConfig)this.getModelElement().nearest(ILaunchConfig.class);
        CoherenceModel model = ((LaunchConfigResource)config.resource()).getCoherenceModel();
        IJavaProject javaProject = model.getJavaProject();
        if (javaProject != null) {
            try {
                IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3) {
                        IPath path = entry.getPath();
                        IResource res = javaProject.getProject().findMember(path.removeFirstSegments(1));
                        if (res instanceof IContainer) {
                            return Collections.singletonList(PathBridge.create((IPath)res.getLocation()));
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }
        return Collections.singletonList(PathBridge.create((IPath)ResourcesPlugin.getWorkspace().getRoot().getLocation()));
    }

    private static final class Resources
    extends NLS {
        public static String label;

        static {
            Resources.initializeMessages((String)SourcePathValueBrowseHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

