/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.coherence.descriptors.operations.IGarExportWizardOp;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.AbsoluteFilePathBrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.FileDialog;

public class AbsoluteDestinationBrowseHandler
extends BrowseActionHandler {
    private FileExtensionsService fileExtensionService;
    private List<String> staticFileExtensionsList;

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.addImage((ImageData)ImageData.readFromClassLoader(AbsoluteFilePathBrowseActionHandler.class, (String)"File.png").required());
        Value property = this.property();
        this.setLabel(property.definition().getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false));
        String staticFileExtensions = def.getParam("extensions");
        if (staticFileExtensions == null) {
            this.fileExtensionService = (FileExtensionsService)property.service(FileExtensionsService.class);
            if (this.fileExtensionService == null) {
                this.staticFileExtensionsList = Collections.emptyList();
            }
        } else {
            this.staticFileExtensionsList = new ArrayList<String>();
            String[] stringArray = staticFileExtensions.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if ((extension = extension.trim()).length() > 0) {
                    this.staticFileExtensionsList.add(extension);
                }
                ++n2;
            }
        }
    }

    protected String browse(Presentation context) {
        List extensions;
        Value value = this.property();
        FileDialog dialog = new FileDialog(((SwtPresentation)context).shell());
        dialog.setText(value.definition().getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false));
        Path path = (Path)value.content();
        IGarExportWizardOp op = (IGarExportWizardOp)this.getModelElement().nearest(IGarExportWizardOp.class);
        String name = (String)op.getProject().content();
        if (name != null) {
            dialog.setFileName(String.valueOf(name) + ".gar");
        }
        if (path != null && path.segmentCount() > 1) {
            dialog.setFilterPath(path.removeLastSegments(1).toOSString());
            dialog.setFileName(path.lastSegment());
        }
        if (!(extensions = this.fileExtensionService == null ? this.staticFileExtensionsList : this.fileExtensionService.extensions()).isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (String extension : extensions) {
                if (buf.length() > 0) {
                    buf.append(';');
                }
                buf.append("*.");
                buf.append(extension);
            }
            dialog.setFilterExtensions(new String[]{buf.toString()});
        }
        return dialog.open();
    }
}

