/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.facets.internal;

import oracle.eclipse.tools.coherence.facets.internal.CoherenceFacetInstallConfig;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.weblogic.facets.WlsGarFacet;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryFacetInstallPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class CoherenceFacetInstallPage
extends LibraryFacetInstallPage {
    private CoherenceFacetInstallConfig config = null;
    private Button createOperationalConfigCheckBox;
    private Button createCacheConfigCheckBox;
    private Button createPofConfigCheckBox;

    public CoherenceFacetInstallPage() {
        super("coherence.install");
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
    }

    public void setConfig(Object config) {
        super.setConfig(config);
        this.config = (CoherenceFacetInstallConfig)config;
    }

    private boolean isGar() {
        for (Object object : this.context.getSelectedProjectFacets()) {
            if (!(object instanceof IProjectFacetVersion) || !WlsGarFacet.FACET.equals(((IProjectFacetVersion)object).getProjectFacet())) continue;
            return true;
        }
        return false;
    }

    protected Control createPageContents(Composite parent) {
        GridData gd;
        Composite rootComposite = new Composite(parent, 0);
        rootComposite.setLayout((Layout)SwtUtil.glayout((int)1, (int)0, (int)0));
        Control librariesControl = super.createPageContents(rootComposite);
        librariesControl.setLayoutData((Object)SwtUtil.gdhfill());
        Composite composite = new Composite(rootComposite, 0);
        composite.setLayout((Layout)SwtUtil.glayout((int)3));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        if (!this.isGar()) {
            this.createOperationalConfigCheckBox = new Button(composite, 32);
            this.createOperationalConfigCheckBox.setText(Resources.createOperationalConfig);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.createOperationalConfigCheckBox.setLayoutData((Object)gd);
            this.createOperationalConfigCheckBox.setSelection(true);
        } else {
            this.config.setProperty("PROP_CREATE_OPERATIONAL_CONFIG", (Object)Boolean.FALSE);
        }
        this.createCacheConfigCheckBox = new Button(composite, 32);
        this.createCacheConfigCheckBox.setText(Resources.createCacheConfig);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.createCacheConfigCheckBox.setLayoutData((Object)gd);
        this.createCacheConfigCheckBox.setSelection(true);
        Label cacheConfigNote = new Label(composite, 64);
        cacheConfigNote.setText(Resources.cacheConfigNote);
        cacheConfigNote.setForeground(parent.getDisplay().getSystemColor(16));
        gd = new GridData(4, 128, true, false, 1, 1);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = 18;
        cacheConfigNote.setLayoutData((Object)gd);
        this.createPofConfigCheckBox = new Button(composite, 32);
        this.createPofConfigCheckBox.setText(Resources.createPofConfig);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.createPofConfigCheckBox.setLayoutData((Object)gd);
        this.createPofConfigCheckBox.setSelection(true);
        if (this.createOperationalConfigCheckBox != null) {
            this.createOperationalConfigCheckBox.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = CoherenceFacetInstallPage.this.createOperationalConfigCheckBox.getSelection();
                    CoherenceFacetInstallConfig cfg = CoherenceFacetInstallPage.this.config;
                    if (selected) {
                        cfg.setProperty("PROP_CREATE_OPERATIONAL_CONFIG", (Object)Boolean.TRUE);
                    } else {
                        cfg.setProperty("PROP_CREATE_OPERATIONAL_CONFIG", (Object)Boolean.FALSE);
                    }
                }
            });
        }
        this.createCacheConfigCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selected = CoherenceFacetInstallPage.this.createCacheConfigCheckBox.getSelection();
                CoherenceFacetInstallConfig cfg = CoherenceFacetInstallPage.this.config;
                if (selected) {
                    cfg.setProperty("PROP_CREATE_CACHE_CONFIG", (Object)Boolean.TRUE);
                } else {
                    cfg.setProperty("PROP_CREATE_CACHE_CONFIG", (Object)Boolean.FALSE);
                }
            }
        });
        this.createPofConfigCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selected = CoherenceFacetInstallPage.this.createPofConfigCheckBox.getSelection();
                CoherenceFacetInstallConfig cfg = CoherenceFacetInstallPage.this.config;
                if (selected) {
                    cfg.setProperty("PROP_CREATE_POF_CONFIG", (Object)Boolean.TRUE);
                } else {
                    cfg.setProperty("PROP_CREATE_POF_CONFIG", (Object)Boolean.FALSE);
                }
            }
        });
        return rootComposite;
    }

    private static final class Resources
    extends NLS {
        public static String pageTitle;
        public static String pageDescription;
        public static String createOperationalConfig;
        public static String createCacheConfig;
        public static String createPofConfig;
        public static String cacheConfigNote;

        static {
            Resources.initializeMessages((String)CoherenceFacetInstallPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

