/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.application.internal;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;

public class OverridePropertyResetActionsContributor
extends PropertyEditorAssistContributor {
    @Text(value="Restore default value")
    private static LocalizableText restoreDefaultValue;
    @Text(value="Clear")
    private static LocalizableText clear;

    static {
        LocalizableText.init(OverridePropertyResetActionsContributor.class);
    }

    public void contribute(PropertyEditorAssistContext context) {
        final Element element = context.getPart().getLocalModelElement();
        final PropertyDef prop = ((PropertyEditorPart)context.getPart()).property().definition();
        if (((PropertyEditorPart)context.getPart()).isReadOnly()) {
            return;
        }
        if (prop instanceof ValueProperty) {
            final PropertyDef overridePropertyProp = element.type().property(String.valueOf(prop.name()) + "Override");
            Value val = element.property((ValueProperty)prop);
            if (val.text(false) != null) {
                DefaultValueService defaultValueService = (DefaultValueService)element.property(prop).service(DefaultValueService.class);
                boolean hasDefaultValue = defaultValueService == null ? false : defaultValueService.value() != null;
                boolean isBooleanType = prop.getTypeClass().equals(Boolean.class);
                String actionText = hasDefaultValue || isBooleanType ? restoreDefaultValue.text() : clear.text();
                PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
                contribution.text("<p><a href=\"action\" nowrap=\"true\">" + OverridePropertyResetActionsContributor.escapeForXml((String)actionText) + "</a></p>");
                contribution.link("action", new Runnable(){

                    @Override
                    public void run() {
                        element.property(overridePropertyProp).clear();
                        element.property(prop).clear();
                    }
                });
                PropertyEditorAssistSection section = context.getSection("actions");
                section.addContribution(contribution.create());
            }
        }
    }
}

