/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.ui.application.internal;

import oracle.eclipse.tools.coherence.descriptors.application.IOverrideProperty;
import oracle.eclipse.tools.common.util.ObjectUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.SapphireDialog;

public class OverridePropertyContributor
extends PropertyEditorAssistContributor {
    static final String OVERRIDE = "Override";
    Element element;
    FilteredListener<PropertyContentEvent> listener;

    public void init(SapphirePart part) {
        super.init(part);
        this.element = part.getLocalModelElement();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                OverridePropertyContributor.this.broadcast();
            }
        };
        this.element.attach(this.listener, String.valueOf(((PropertyEditorPart)part).property().name()) + OVERRIDE);
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null && this.element != null) {
            this.element.detach(this.listener);
            this.listener = null;
        }
    }

    public void contribute(final PropertyEditorAssistContext context) {
        final Element element = context.getPart().getLocalModelElement();
        PropertyDef property = ((PropertyEditorPart)context.getPart()).property().definition();
        final PropertyDef overridePropertyProperty = element.type().property(String.valueOf(property.name()) + OVERRIDE);
        if (overridePropertyProperty != null && (property instanceof ValueProperty && element.property((ValueProperty)property).text(false) != null || overridePropertyProperty instanceof ValueProperty && element.property((ValueProperty)overridePropertyProperty).text(false) != null)) {
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            final String paramName = element.property((ValueProperty)overridePropertyProperty).text(false);
            contribution.text(this.buildOverridePropertyText(paramName));
            contribution.link("action", new Runnable(){

                @Override
                public void run() {
                    String newName;
                    IOverrideProperty overrideProperty = (IOverrideProperty)IOverrideProperty.TYPE.instantiate();
                    overrideProperty.setName(element.property((ValueProperty)overridePropertyProperty).text(false));
                    SapphireDialog dialog = new SapphireDialog(context.getShell(), (Element)overrideProperty, DefinitionLoader.context(this.getClass()).sdef("CoherenceApplicationEditor").dialog("override-property"));
                    if (dialog.open() == 0 && !ObjectUtil.equals((Object)paramName, (Object)(newName = overrideProperty.getName().text(false)))) {
                        element.property((ValueProperty)overridePropertyProperty).write((Object)newName);
                    }
                }
            });
            PropertyEditorAssistSection section = context.getSection(paramName == null ? "actions" : "info");
            section.addContribution(contribution.create());
        }
    }

    private String buildOverridePropertyText(String overrideProperty) {
        StringBuffer buf = new StringBuffer();
        buf.append("<p>");
        if (overrideProperty == null) {
            buf.append("<a href=\"action\" nowrap=\"true\">");
            buf.append(Resources.addOverrideProperty);
            buf.append("</a>");
        } else {
            buf.append(Resources.overrideProperty);
            buf.append(" \"");
            buf.append("<a href=\"action\" nowrap=\"true\">");
            buf.append(overrideProperty);
            buf.append("</a>");
            buf.append("\".");
        }
        buf.append("</p>");
        return buf.toString();
    }

    private static final class Resources
    extends NLS {
        public static String overrideProperty;
        public static String addOverrideProperty;

        static {
            Resources.initializeMessages((String)OverridePropertyContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

