/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.DataTypeJavaDescriptorDelegate;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.DelegatingJavaTypeDescriptor;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.OssSymbolAdaptersFactory;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.PropertySymbolDelegate;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.symbol.IBeanPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;

public class BeanPropertySymbolDelegate
extends PropertySymbolDelegate {
    private String _description;
    private final List<String> _typeParameters;

    public BeanPropertySymbolDelegate(JDTDataType.JavaField field, IModelContext modelContext) {
        this(field, Collections.EMPTY_LIST, modelContext);
    }

    public BeanPropertySymbolDelegate(JDTDataType.JavaField field, List<String> typeParameters, IModelContext modelContext) {
        super((DataType.Field)field, modelContext);
        this._typeParameters = typeParameters;
    }

    @Override
    public String getDetailedDescription() {
        if (this._description == null) {
            IBeanPropertySymbol originalSymbol = SymbolFactory.eINSTANCE.createIBeanPropertySymbol();
            originalSymbol.setName(this.getField().getName());
            originalSymbol.setReadable(true);
            originalSymbol.setWritable(true);
            originalSymbol.setOwner((IJavaTypeDescriptor2)this.getTypeDescriptor());
            this._description = originalSymbol.getDetailedDescription();
        }
        return this._description;
    }

    protected IJavaTypeDescriptor2 createFromDataType(DataType dataType, IModelContext modelContext) {
        DelegatingJavaTypeDescriptor descriptor = OssSymbolAdaptersFactory.eINSTANCE.createDelegatingJavaTypeDescriptor();
        descriptor.getTypeParameterSignatures().addAll(this._typeParameters);
        descriptor.setTypeDescriptorDelegate(new DataTypeJavaDescriptorDelegate(dataType, modelContext));
        return descriptor;
    }

    public JDTDataType.JavaField getField() {
        return (JDTDataType.JavaField)super.getField();
    }

    @Override
    public boolean isWritable() {
        if (this.getField() != null) {
            return this.getField().isWritable();
        }
        return false;
    }

    @Override
    public boolean isReadable() {
        if (this.getField() != null) {
            return this.getField().isReadable();
        }
        return false;
    }
}

