/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.DelegatingBeanPropertySymbol;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.OssSymbolAdaptersFactory;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.BeanPropertySymbolDelegate;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.DataTypeDescriptorDelegate;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;

public class DataTypeJavaDescriptorDelegate
extends DataTypeDescriptorDelegate {
    private JDTBeanIntrospector _beanIntrospector;

    public DataTypeJavaDescriptorDelegate(DataType dataType, IModelContext modelContext) {
        super(dataType, modelContext);
    }

    @Override
    protected IPropertySymbol createPropertySymbol(DataType.Field field) {
        if (!(field instanceof JDTDataType.JavaField)) {
            throw new IllegalArgumentException("field must be a java field");
        }
        List<String> typeParams = this.maybeGetTypeParameters((JDTDataType.JavaField)field);
        DelegatingBeanPropertySymbol propertySymbol = OssSymbolAdaptersFactory.eINSTANCE.createDelegatingBeanPropertySymbol();
        BeanPropertySymbolDelegate value = new BeanPropertySymbolDelegate((JDTDataType.JavaField)field, typeParams, this._modelContext);
        propertySymbol.setDelegate(value);
        return propertySymbol;
    }

    private List<String> maybeGetTypeParameters(JDTDataType.JavaField field) {
        JDTBeanIntrospector introspector;
        if ((field.getType().isSubClass("java.util.List") || field.getType().isSubClass("java.util.Map")) && (introspector = this.getJDTBeanIntrospector()) != null) {
            Map properties = introspector.getProperties();
            JDTBeanProperty jdtBeanProperty = (JDTBeanProperty)properties.get(field.getName());
            return jdtBeanProperty.getTypeParameterSignatures();
        }
        return Collections.emptyList();
    }

    private JDTBeanIntrospector getJDTBeanIntrospector() {
        IType type;
        if (this._beanIntrospector == null && (type = this.getType()) != null) {
            this._beanIntrospector = new JDTBeanIntrospector(type);
        }
        return this._beanIntrospector;
    }

    @Override
    public IType getType() {
        IProject eclipseProject;
        IJavaProject javaProject;
        IType type = null;
        Project project = this.getDataType().getProject();
        if (project != null && (javaProject = JavaCore.create((IProject)(eclipseProject = project.getEclipseProject()))) != null) {
            String resolvedTypeSig = this.getDataType().getName();
            if (resolvedTypeSig != null && !resolvedTypeSig.startsWith(String.valueOf('['))) {
                resolvedTypeSig = Signature.createTypeSignature((String)resolvedTypeSig, (boolean)true);
            }
            if (resolvedTypeSig != null) {
                type = TypeUtil.resolveType((IJavaProject)javaProject, (String)resolvedTypeSig);
            }
        }
        return type;
    }
}

