/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.variable.oss;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.ImplicitVariable;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.SymbolUtil;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.application.common.services.variables.VariablesIterator;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.webtier.jsf.variable.FacesExternalVariable;
import oracle.eclipse.tools.webtier.jsf.variable.JSFImplicitVariable;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.DelegatingBeanInstanceSymbol;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.DelegatingInstanceSymbol;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.OssSymbolAdaptersFactory;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.BeanInstanceSymbolDelegate;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.InstanceSymbolDelegate;
import oracle.eclipse.tools.webtier.jsf.variable.oss.symboladapters.delegates.MapInstanceSymbolDelegate;
import oracle.eclipse.tools.webtier.jsp.variables.JSPImplicitScopeVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IBoundedMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.el.AbstractDTVariableResolver;

public class VariableResolver
extends AbstractDTVariableResolver {
    private final IModelContext _context;
    private final VariableQuery.QueryMatcher _matcher;
    private final boolean _useWorkingCopy;
    private List<Variable> _documentVariablesCache;

    public VariableResolver(IModelContext context, VariableQuery.QueryMatcher matcher) {
        this(context, matcher, true);
    }

    public VariableResolver(IModelContext context, VariableQuery.QueryMatcher matcher, boolean useWorkingCopy) {
        this(context, matcher, useWorkingCopy, null);
    }

    public VariableResolver(IModelContext context, VariableQuery.QueryMatcher matcher, boolean useWorkingCopy, List<Variable> docCache) {
        this._context = context;
        this._matcher = matcher;
        this._useWorkingCopy = useWorkingCopy;
        this._documentVariablesCache = docCache;
    }

    public ISymbol[] getAllVariables(DTFacesContext facesContext, IAdaptable externalContextKey) {
        IFile file;
        IProject project;
        ArrayList<IInstanceSymbol> symbols = new ArrayList<IInstanceSymbol>();
        IDocument document = this.getDocument(externalContextKey);
        if (document != null && (project = document.getProject().getEclipseProject()) != null && (file = (IFile)externalContextKey.getAdapter(IFile.class)) != null) {
            int offset = SymbolUtil.getOffset((IModelContext)this._context);
            List<Variable> vars = this.getMatchingVars(document, offset);
            for (Variable var : vars) {
                symbols.add(this.createInstanceSymbol(project, var, ERuntimeSource.OTHER_LITERAL, file));
            }
        }
        if (!symbols.isEmpty()) {
            return symbols.toArray(new ISymbol[symbols.size()]);
        }
        return new ISymbol[0];
    }

    private List<Variable> getMatchingVars(IDocument document, int offset) {
        if (this._documentVariablesCache == null) {
            return new DocumentVariableQuery(document, offset, this._useWorkingCopy).findVariable(this._matcher);
        }
        VariablesIterator iterator = VariablesController.getInstance().iterator(document.getFile(), this._useWorkingCopy, false, this._matcher);
        this._documentVariablesCache = iterator.getVariables();
        ArrayList<Variable> matchedVars = new ArrayList<Variable>(this._documentVariablesCache.size());
        for (Variable var : this._documentVariablesCache) {
            if (!this._matcher.matches((Object)var) || offset != -1 && !var.isInScope(offset)) continue;
            matchedVars.add(var);
        }
        return matchedVars;
    }

    public ISymbol resolveVariable(DTFacesContext context, String name, IAdaptable externalContextKey) {
        if (name == null || name.length() == 0) {
            return null;
        }
        ISymbol[] variables = this.getAllVariables(context, externalContextKey);
        ISymbol foundVariable = null;
        ISymbol[] iSymbolArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            ISymbol variable = iSymbolArray[n2];
            if (name.equals(variable.getName())) {
                foundVariable = variable;
                break;
            }
            ++n2;
        }
        return foundVariable;
    }

    private IInstanceSymbol createInstanceSymbol(IProject project, Variable variable, ERuntimeSource runtimeSource, IFile externalContextKey) {
        if (variable instanceof FacesExternalVariable) {
            DelegatingBeanInstanceSymbol beanSymbol = OssSymbolAdaptersFactory.eINSTANCE.createDelegatingBeanInstanceSymbol();
            beanSymbol.setDelegate(new BeanInstanceSymbolDelegate(variable, (IModelContext)new FilePositionContext(SymbolUtil.getOffset((IModelContext)this._context), externalContextKey)));
            beanSymbol.setRuntimeSource(ERuntimeSource.MANAGED_BEAN_SYMBOL_LITERAL);
            return beanSymbol;
        }
        if (variable.getType() instanceof JavaResourceBundleDataType) {
            return this.createResourceBundleSymbol(project, variable, (JavaResourceBundleDataType)variable.getType(), runtimeSource, externalContextKey);
        }
        if (variable instanceof JSFImplicitVariable) {
            return ((JSFImplicitVariable)variable).getSymbol();
        }
        if (variable instanceof JSPImplicitScopeVariable) {
            return this.createJSPImplicitScopeVariable((JSPImplicitScopeVariable)variable, externalContextKey);
        }
        if (variable instanceof ImplicitVariable) {
            return this.createDefaultInstanceSymbol(variable, runtimeSource, externalContextKey);
        }
        if (variable.getType() instanceof JDTDataType) {
            DelegatingBeanInstanceSymbol javaSymbol = OssSymbolAdaptersFactory.eINSTANCE.createDelegatingBeanInstanceSymbol();
            javaSymbol.setDelegate(new BeanInstanceSymbolDelegate(variable, (IModelContext)new FilePositionContext(SymbolUtil.getOffset((IModelContext)this._context), externalContextKey)));
            javaSymbol.setRuntimeSource(runtimeSource);
            return javaSymbol;
        }
        return this.createDefaultInstanceSymbol(variable, runtimeSource, externalContextKey);
    }

    private IInstanceSymbol createDefaultInstanceSymbol(Variable variable, ERuntimeSource runtimeSource, IFile file) {
        DelegatingInstanceSymbol instanceSymbol = OssSymbolAdaptersFactory.eINSTANCE.createDelegatingInstanceSymbol();
        instanceSymbol.setDelegate(new InstanceSymbolDelegate(variable, (IModelContext)new FilePositionContext(SymbolUtil.getOffset((IModelContext)this._context), file)));
        if (runtimeSource != null) {
            instanceSymbol.setRuntimeSource(runtimeSource);
        }
        return instanceSymbol;
    }

    private IInstanceSymbol createJSPImplicitScopeVariable(JSPImplicitScopeVariable variable, IFile externalContextKey) {
        IBoundedMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIBoundedMapTypeDescriptor();
        typeDesc.setEnumType(false);
        typeDesc.setImmutable(false);
        typeDesc.setMapSource((Map)new ScopeMap(this, externalContextKey, variable.getScope()));
        IInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIInstanceSymbol();
        symbol.setName(variable.getName());
        symbol.setReadable(true);
        symbol.setWritable(true);
        symbol.setRuntimeSource(ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        return symbol;
    }

    private IInstanceSymbol createResourceBundleSymbol(IProject project, Variable variable, JavaResourceBundleDataType type, ERuntimeSource runtimeSource, IFile file) {
        DelegatingInstanceSymbol bundleSymbol = OssSymbolAdaptersFactory.eINSTANCE.createDelegatingInstanceSymbol();
        bundleSymbol.setDelegate(new MapInstanceSymbolDelegate((IFilePositionContext)new FilePositionContext(SymbolUtil.getOffset((IModelContext)this._context), file), variable));
        bundleSymbol.setRuntimeSource(ERuntimeSource.OTHER_LITERAL);
        return bundleSymbol;
    }

    private IDocument getDocument(IAdaptable adaptable) {
        IFile file = (IFile)adaptable.getAdapter(IFile.class);
        if (file != null) {
            return (IDocument)file.getAdapter(IDocument.class);
        }
        return null;
    }

    private static class ScopeMap
    extends AbstractMap {
        private final IFile _externalContextKey;
        private final VariableResolver _variableResolver;

        ScopeMap(final VariableResolver variableResolver, IFile externalContextKey, final Variable.SCOPE scopeMask) {
            this._variableResolver = new VariableResolver(variableResolver._context, new VariableQuery.QueryMatcher(){

                public boolean matches(Variable variable) {
                    return variableResolver._matcher.matches((Object)variable) && variable.getScope() == scopeMask;
                }
            });
            this._externalContextKey = externalContextKey;
        }

        @Override
        public Set entrySet() {
            ISymbol[] allVariables = this._variableResolver.getAllVariables(null, (IAdaptable)this._externalContextKey);
            HashMap<String, ISymbol> symbols = new HashMap<String, ISymbol>();
            ISymbol[] iSymbolArray = allVariables;
            int n = allVariables.length;
            int n2 = 0;
            while (n2 < n) {
                ISymbol var = iSymbolArray[n2];
                symbols.put(var.getName(), var);
                ++n2;
            }
            return symbols.entrySet();
        }
    }
}

