/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.variable.oss;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTimeMatcher;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.webtier.jsf.variable.oss.AbstractOEPEContextSymbolResolver;
import oracle.eclipse.tools.webtier.jsf.variable.oss.VariableResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;

public class OEPEContextSymbolResolver
extends AbstractOEPEContextSymbolResolver {
    private final VariableResolver _variableResolver;
    private static final Map<IDocument, List<Variable>> FILE_VAR_CACHE = new HashMap<IDocument, List<Variable>>();
    private static final DocumentListener LISTENER = new DocumentListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OEPEContextSymbolResolver(IStructuredDocumentContext context) {
        super((IModelContext)context, (VariableQuery.QueryMatcher)ResolutionTimeMatcher.RUN_TIME_MATCHER);
        List<Variable> vars = null;
        IDocument doc = context.getStructuredDocument();
        if (doc != null) {
            boolean inCache = true;
            Map<IDocument, List<Variable>> map = FILE_VAR_CACHE;
            synchronized (map) {
                vars = FILE_VAR_CACHE.get(doc);
                if (vars == null) {
                    inCache = false;
                    vars = new ArrayList<Variable>();
                    FILE_VAR_CACHE.put(doc, vars);
                    doc.addDocumentListener((IDocumentListener)LISTENER);
                }
            }
            if (!inCache) {
                vars.addAll(VariablesController.getInstance().iterator(this.getFile(), true, false, null).getVariables());
            }
        }
        this._variableResolver = new VariableResolver((IModelContext)context, this._matcher, true, vars);
    }

    public ISymbol getVariable(String name) {
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance((IProject)file.getProject())) != null) {
            DTFacesContext facesContext = manager.getFacesContext(file);
            return this._variableResolver.resolveVariable(facesContext, name, (IAdaptable)file);
        }
        return null;
    }

    public ISymbol[] getAllVariables() {
        DTFacesContext facesContext;
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance((IProject)file.getProject())) != null && (facesContext = manager.getFacesContext(file)) != null) {
            return this._variableResolver.getAllVariables(facesContext, (IAdaptable)file);
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    public ISymbol getProperty(ISymbol symbol, Object propertyName) {
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance((IProject)file.getProject())) != null) {
            return manager.getPropertyResolver().getProperty(symbol, propertyName);
        }
        return null;
    }

    public ISymbol[] getProperties(ISymbol symbol) {
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance((IProject)file.getProject())) != null) {
            return manager.getPropertyResolver().getAllProperties(symbol);
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    public IMethodSymbol getMethod(IObjectSymbol base, Object methodName) {
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance((IProject)file.getProject())) != null) {
            return manager.getMethodResolver().getMethod(base, methodName);
        }
        return null;
    }

    public ISymbol[] getMethods(IObjectSymbol base) {
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance((IProject)file.getProject())) != null) {
            return manager.getMethodResolver().getMethods(base);
        }
        return new IMethodSymbol[0];
    }

    @Override
    public boolean canResolveContext(IModelContext modelContext) {
        return modelContext.getAdapter(IStructuredDocumentContext.class) != null;
    }

    private static class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentAboutToBeChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            if (document != null) {
                Map map = FILE_VAR_CACHE;
                synchronized (map) {
                    FILE_VAR_CACHE.remove(document);
                    document.removeDocumentListener((IDocumentListener)this);
                }
            }
        }

        public void documentChanged(DocumentEvent event) {
        }
    }
}

