/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.variable.oss;

import oracle.eclipse.tools.webtier.jsf.variable.oss.AbstractOEPEContextSymbolResolver;
import oracle.eclipse.tools.webtier.jsf.variable.oss.ImmediateContextSymbolMatcher;
import oracle.eclipse.tools.webtier.jsf.variable.oss.PropertyResolver;
import oracle.eclipse.tools.webtier.jsf.variable.oss.VariableResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.InitializedSymbolFactory;

public class ImmediateContextSymbolResolver
extends AbstractOEPEContextSymbolResolver {
    private final VariableResolver _variableResolver;
    private final PropertyResolver _propertyResolver;

    ImmediateContextSymbolResolver(IStructuredDocumentContext context) {
        super((IModelContext)context, new ImmediateContextSymbolMatcher());
        this._variableResolver = new VariableResolver((IModelContext)context, this._matcher);
        this._propertyResolver = new PropertyResolver();
    }

    public ISymbol getVariable(String name) {
        IFile file = this.getFile();
        ISymbol variable = null;
        if (file != null) {
            variable = this._variableResolver.resolveVariable(null, name, (IAdaptable)file);
        }
        if (variable == null) {
            variable = new InitializedSymbolFactory().createUnknownInstanceSymbol(name, ERuntimeSource.OTHER_LITERAL);
        }
        return variable;
    }

    public ISymbol[] getAllVariables() {
        IFile file = this.getFile();
        if (file != null) {
            return this._variableResolver.getAllVariables(null, (IAdaptable)file);
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    public ISymbol getProperty(ISymbol symbol, Object propertyName) {
        return this._propertyResolver.getProperty(symbol, propertyName);
    }

    public ISymbol[] getProperties(ISymbol symbol) {
        return this._propertyResolver.getAllProperties(symbol);
    }

    public IMethodSymbol getMethod(IObjectSymbol base, Object methodName) {
        return null;
    }

    public ISymbol[] getMethods(IObjectSymbol base) {
        return new IMethodSymbol[0];
    }

    @Override
    public boolean canResolveContext(IModelContext modelContext) {
        return modelContext.getAdapter(IStructuredDocumentContext.class) != null;
    }
}

