/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.variable;

import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.AbstractVariablesDiscoveryParticipant;
import oracle.eclipse.tools.application.common.services.variables.ExternalVariable;
import oracle.eclipse.tools.application.common.services.variables.IVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.jsf.config.JSFConfigFileContentTypeFilter;
import oracle.eclipse.tools.webtier.jsf.variable.FacesBundleExternalVariable;
import oracle.eclipse.tools.webtier.jsf.variable.FacesExternalVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.NodeList;

public class JSFConfigVariablesDiscoveryParticipant
extends AbstractVariablesDiscoveryParticipant {
    public void discover(IResourceDiscoveryContext context, IProgressMonitor monitor) {
        if (this.isJSFConfigFile(context)) {
            IFile file = (IFile)context.getResource();
            IDiscoveryContext projectContext = this.getProjectContext();
            IVariablesCache cache = (IVariablesCache)projectContext.getAdapter(IVariablesCache.class);
            if (cache != null) {
                for (Variable var : cache.getVariables()) {
                    IResource markerRes;
                    IMarker marker;
                    if (!(var instanceof FacesExternalVariable) && !(var instanceof FacesBundleExternalVariable) || (marker = var.getMarker()) == null || !file.equals((Object)(markerRes = marker.getResource()))) continue;
                    cache.remove(var);
                }
                super.discover(context, monitor);
            }
        }
    }

    private boolean isJSFConfigFile(IResourceDiscoveryContext context) {
        return context.getResource().getType() == 1 && JSFConfigFileContentTypeFilter.getInstance().match((IResourceContext)context);
    }

    public boolean visit(IDOMElement element, IFile file, List<ExternalVariable> discoveredVars) {
        Project project = (Project)file.getProject().getAdapter(Project.class);
        String elementName = element.getNodeName();
        if ("faces-config".equals(elementName)) {
            return true;
        }
        if ("referenced-bean".equals(elementName)) {
            FacesExternalVariable externalVar = FacesExternalVariable.fromBeanElement(project, element, file);
            if (externalVar != null) {
                discoveredVars.add((ExternalVariable)externalVar);
            }
        } else if ("managed-bean".equals(elementName)) {
            FacesExternalVariable externalVar;
            NodeList scopeElems = element.getElementsByTagName("managed-bean-scope");
            if (scopeElems.getLength() > 0 && (externalVar = FacesExternalVariable.fromBeanElement(project, element, file)) != null) {
                discoveredVars.add((ExternalVariable)externalVar);
            }
        } else {
            FacesBundleExternalVariable externalVar;
            if ("application".equals(elementName)) {
                return true;
            }
            if ("resource-bundle".equals(elementName) && (externalVar = FacesBundleExternalVariable.fromeResourceBundleElement(project, element, file)) != null) {
                discoveredVars.add(externalVar);
            }
        }
        return false;
    }
}

