/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.variable;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.application.common.services.variables.ManagedBeanExternalVariable;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.webtier.jsf.variable.NodeUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FacesExternalVariable
extends ManagedBeanExternalVariable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String description;
    private TYPE _beanType;

    public static FacesExternalVariable fromBeanElement(Project project, IDOMElement beanElement, IFile file) {
        NodeList mapEntryNodes;
        int i;
        String prefix = null;
        boolean isReferenced = false;
        if ("managed-bean".equals(beanElement.getNodeName())) {
            prefix = "managed";
        } else if ("referenced-bean".equals(beanElement.getNodeName())) {
            prefix = "referenced";
            isReferenced = true;
        } else {
            return null;
        }
        StructuredDocumentResourceLocationFactory factory = new StructuredDocumentResourceLocationFactory(file);
        ResourceLocation location = factory.createForEntireElement(beanElement);
        NodeList nameNodes = beanElement.getElementsByTagName(String.valueOf(prefix) + "-bean-name");
        if (nameNodes.getLength() != 1) {
            return null;
        }
        String name = NodeUtil.getNodeText(nameNodes.item(0));
        NodeList classNodes = beanElement.getElementsByTagName(String.valueOf(prefix) + "-bean-class");
        if (classNodes.getLength() != 1) {
            return null;
        }
        String className = NodeUtil.getNodeText(classNodes.item(0));
        DataType dt = DataType.getUnspecifiedType();
        IDatatypeProvider dtp = (IDatatypeProvider)project.getAppService(IDatatypeProvider.class);
        if (dtp != null) {
            dt = dtp.getDataType(className, null);
        }
        Variable.SCOPE scopeValue = Variable.SCOPE.SESSION_SCOPE;
        if (!isReferenced) {
            NodeList scopeNodes = beanElement.getElementsByTagName(String.valueOf(prefix) + "-bean-scope");
            if (scopeNodes.getLength() != 1) {
                return null;
            }
            String scope = NodeUtil.getNodeText(scopeNodes.item(0));
            if ("request".equals(scope)) {
                scopeValue = Variable.SCOPE.REQUEST_SCOPE;
            } else if ("application".equals(scope)) {
                scopeValue = Variable.SCOPE.APPLICATION_SCOPE;
            } else if ("none".equals(scope)) {
                scopeValue = Variable.SCOPE.NONE_SCOPE;
            } else if ("view".equals(scope)) {
                scopeValue = Variable.SCOPE.VIEW_SCOPE;
            }
        }
        String desc = null;
        NodeList descriptionNodes = beanElement.getElementsByTagName("description");
        if (descriptionNodes.getLength() > 0) {
            StringBuilder descBuilder = new StringBuilder();
            i = 0;
            while (i < descriptionNodes.getLength()) {
                descBuilder.append("<p>");
                descBuilder.append(NodeUtil.getNodeText(descriptionNodes.item(i)));
                descBuilder.append("</p>");
                ++i;
            }
            desc = descBuilder.toString();
        }
        if ((mapEntryNodes = beanElement.getElementsByTagName("map-entries")).getLength() > 0 && dt instanceof JDTDataType) {
            i = 0;
            while (i < mapEntryNodes.getLength()) {
                Node meNode = mapEntryNodes.item(i);
                if (meNode instanceof Element) {
                    NodeList entryNodes = ((Element)meNode).getElementsByTagName("map-entry");
                    int j = 0;
                    while (j < entryNodes.getLength()) {
                        Node entryNode = entryNodes.item(j);
                        if (entryNode instanceof Element) {
                            String keyName;
                            Node key;
                            NodeList keyNodes = ((Element)entryNode).getElementsByTagName("key");
                            NodeList valueNodes = ((Element)entryNode).getElementsByTagName("value");
                            if (keyNodes.getLength() > 0 && (key = keyNodes.item(0)) instanceof Element && (keyName = NodeUtil.getNodeText(key)) != null && !keyName.trim().isEmpty()) {
                                Node valueNode;
                                String nodeText;
                                String value = "";
                                if (valueNodes.getLength() > 0 && (nodeText = NodeUtil.getNodeText(valueNode = valueNodes.item(0))) != null && !nodeText.trim().isEmpty()) {
                                    value = nodeText.trim();
                                }
                                ((JDTDataType)dt).addInjectedFields((DataType.Field)new JDTDataType.MapEntryJavaField(keyName.trim(), value));
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return new FacesExternalVariable(name, desc, dt, scopeValue, FacesExternalVariable.getVarResTimeByVersion(project), location, isReferenced ? TYPE.REFERENCED_BEAN : TYPE.MANAGED_BEAN);
    }

    private FacesExternalVariable(String name, String description, DataType type, Variable.SCOPE scope, ResolutionTime resolutionTime, ResourceLocation location, TYPE beanType) {
        super(name, type, scope, resolutionTime, location);
        assert (scope == Variable.SCOPE.PAGE_SCOPE || scope == Variable.SCOPE.REQUEST_SCOPE || scope == Variable.SCOPE.SESSION_SCOPE || scope == Variable.SCOPE.APPLICATION_SCOPE || scope == Variable.SCOPE.NONE_SCOPE || scope == Variable.SCOPE.VIEW_SCOPE);
        this._beanType = beanType;
        this.description = description;
    }

    public static ResolutionTime getVarResTimeByVersion(Project project) {
        ITechnologyExtension techId = project.getTechnologyExtensionById("jsf");
        String version = techId.getVersion();
        if ("1.0".equals(version) || "1.1".equals(version)) {
            return ResolutionTime.PAGE_RUN;
        }
        return ResolutionTime.PAGE_RUN_OR_COMPILE;
    }

    public String getDescription() {
        String scope;
        DataType dt;
        StringBuilder additionalInfo = new StringBuilder();
        if (this.getName() != null) {
            additionalInfo.append((CharSequence)this.createInfoParagraph(Messages.getString("DefaultBeanSymbolSourceProvider.AdditionalInformation.Name"), this.getName()));
        }
        if ((dt = this.getType()) != null && !dt.isUnknown()) {
            additionalInfo.append((CharSequence)this.createInfoParagraph(Messages.getString("DefaultBeanSymbolSourceProvider.AdditionalInformation.Type"), dt.getDisplayName(false)));
        }
        switch (this.getScope()) {
            case REQUEST_SCOPE: {
                scope = "request";
                break;
            }
            case APPLICATION_SCOPE: {
                scope = "application";
                break;
            }
            case SESSION_SCOPE: {
                scope = "session";
                break;
            }
            case NONE_SCOPE: {
                scope = "none";
                break;
            }
            case VIEW_SCOPE: {
                scope = "view";
                break;
            }
            default: {
                scope = null;
            }
        }
        if (scope != null) {
            additionalInfo.append((CharSequence)this.createInfoParagraph(Messages.getString("DefaultBeanSymbolSourceProvider.AdditionalInformation.Scope"), scope));
        }
        if (this.description != null && this.description.length() > 0) {
            additionalInfo.append((CharSequence)this.createDescriptionParagraph(this.description));
        }
        return additionalInfo.toString();
    }

    private StringBuilder createDescriptionParagraph(String desc) {
        StringBuilder descriptionParagraph = new StringBuilder();
        descriptionParagraph.append("<p><b>" + Messages.getString("DefaultBeanSymbolSourceProvider.AdditionalInformation.ConfigurationDescription"));
        descriptionParagraph.append(" </b></p><br>");
        descriptionParagraph.append(desc);
        return descriptionParagraph;
    }

    private StringBuilder createInfoParagraph(String label, String value) {
        StringBuilder newParagraph = new StringBuilder();
        newParagraph.append("<p><b>");
        newParagraph.append(label);
        newParagraph.append(" </b>");
        newParagraph.append(value);
        newParagraph.append("</p>");
        return newParagraph;
    }

    public boolean isManagedBean() {
        return this._beanType == TYPE.MANAGED_BEAN;
    }

    public boolean isReferencedBean() {
        return this._beanType == TYPE.REFERENCED_BEAN;
    }

    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        hcu.hash(super.hashCode());
        hcu.hash((Object)this._beanType);
        hcu.hash((Object)this.description);
        return hcu.getHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FacesExternalVariable) {
            FacesExternalVariable other = (FacesExternalVariable)obj;
            return super.equals((Object)other) && (this._beanType == null ? other._beanType == null : this._beanType.equals((Object)other._beanType)) && (this.getDescription() == null ? other.getDescription() == null : this.getDescription().equals(other.getDescription()));
        }
        return false;
    }

    private static class Messages {
        private static final String BUNDLE_NAME = "oracle.eclipse.tools.webtier.jsf.variable.messages";
        private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("oracle.eclipse.tools.webtier.jsf.variable.messages");

        private Messages() {
        }

        public static String getString(String key) {
            try {
                return RESOURCE_BUNDLE.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                return String.valueOf('!') + key + '!';
            }
        }
    }

    private static enum TYPE {
        MANAGED_BEAN,
        REFERENCED_BEAN;

    }
}

