/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.variable;

import java.io.Serializable;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ExternalVariable;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.webtier.jsf.variable.FacesExternalVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FacesBundleExternalVariable
extends ExternalVariable
implements Serializable {
    private static final long serialVersionUID = 1L;

    private FacesBundleExternalVariable(DataType type, String varName, Project project, ResourceLocation location) {
        super(varName, type, Variable.SCOPE.SESSION_SCOPE, FacesExternalVariable.getVarResTimeByVersion(project), location);
    }

    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        hcu.hash(super.hashCode());
        return hcu.getHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FacesBundleExternalVariable) {
            return super.equals(obj);
        }
        return false;
    }

    public static FacesBundleExternalVariable fromeResourceBundleElement(Project project, IDOMElement element, IFile file) {
        IDOMElement baseName;
        String baseNameStr;
        NodeList baseNameElems;
        IDOMElement var;
        String varName;
        NodeList varElems = element.getElementsByTagName("var");
        if (varElems.getLength() > 0 && varElems.item(0) instanceof IDOMElement && (varName = FacesBundleExternalVariable.getNodeText((Node)(var = (IDOMElement)varElems.item(0)))) != null && varName.length() > 0 && (baseNameElems = element.getElementsByTagName("base-name")).getLength() > 0 && baseNameElems.item(0) instanceof IDOMElement && (baseNameStr = FacesBundleExternalVariable.getNodeText((Node)(baseName = (IDOMElement)baseNameElems.item(0)))) != null && baseNameStr.length() > 0) {
            StructuredDocumentResourceLocationFactory factory = new StructuredDocumentResourceLocationFactory(file);
            ResourceLocation location = factory.createForEntireElement(element);
            DataType type = FacesBundleExternalVariable.getBundleDataType(project, baseNameStr);
            return new FacesBundleExternalVariable(type, varName, project, location);
        }
        return null;
    }

    private static DataType getBundleDataType(Project project, String baseName) {
        IDatatypeProvider dtp = (IDatatypeProvider)project.getAppService(IDatatypeProvider.class);
        if (dtp != null) {
            return new JavaResourceBundleDataType(dtp.getIntrospector(), project, baseName);
        }
        throw new IllegalStateException("Web app must have a data type provider");
    }

    private static String getNodeText(Node parent) {
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1) {
            return children.item(0).getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 5) {
                String reference = ((EntityReference)child).getNodeValue();
                if (reference == null && child.getNodeName() != null) {
                    reference = "&" + child.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(reference.trim());
                }
            } else {
                s.append(child.getNodeValue().trim());
            }
            child = child.getNextSibling();
        }
        return s.toString().trim();
    }
}

