/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.refactoring.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.refactoring.BundleRefactoringUtil;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import oracle.eclipse.tools.webtier.jsf.refactoring.internal.JsfRefactoringUtil;
import oracle.eclipse.tools.webtier.jsf.refactoring.internal.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;

public class MessageBundleRenameParticipant
extends RenameParticipant {
    private static final String PROPERTIES = "properties";
    private static final String PROPERTIES_EXT = ".properties";
    private IFile fileToRename;
    private Map<IFile, Locale> localeToBundleMap = new HashMap<IFile, Locale>();
    private Set<IArtifactReference> referencesToProcess = new HashSet<IArtifactReference>();
    private String oldReferenceName;
    private String newReferenceName;

    protected boolean initialize(Object element) {
        IFile file;
        IArtifact artifact = RefactoringUtil.elementToArtifact((Object)element);
        if (artifact instanceof ResourceArtifact && artifact.getLocation() != null && artifact.getLocation().getResource() instanceof IFile && BundleRefactoringUtil.isBundleFile((IResource)(file = (IFile)artifact.getLocation().getResource()))) {
            ArtifactController controller = ArtifactControllerFactory.getController();
            Project project = (Project)file.getProject().getAdapter(Project.class);
            IAppLocalizer appService = (IAppLocalizer)project.getAppService(IAppLocalizer.class);
            Set allBaseNames = appService.getAllBaseNames();
            for (String baseName : allBaseNames) {
                String fullName = JsfRefactoringUtil.getFullyQualifiedFileName(file);
                if (!fullName.startsWith(baseName)) continue;
                this.fileToRename = file;
                this.oldReferenceName = JsfRefactoringUtil.getFullyQualifiedFileName((IFile)element);
                this.newReferenceName = JsfRefactoringUtil.getFullyQualifiedFileName(((IFile)element).getParent(), this.getArguments().getNewName());
                Collection availableLocales = appService.getAvailableLocales(baseName);
                for (Locale locale : availableLocales) {
                    IBundleResource bundle = appService.resolveBundle(baseName, locale);
                    if (bundle == null) continue;
                    IFile bundleFile = bundle.getUnderlyingResource();
                    IArtifact a = RefactoringUtil.ensureResourceArtifact((IResource)bundleFile);
                    Set artifactReferers = controller.getArtifactReferers(a);
                    this.referencesToProcess.addAll(artifactReferers);
                    this.localeToBundleMap.put(bundle.getUnderlyingResource(), locale);
                }
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return Messages.MessageBundleRenameParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        String bundleFileName = JsfRefactoringUtil.getFullyQualifiedFileName(this.fileToRename.getParent(), this.getArguments().getNewName());
        return this.validateChangeToBaseName(bundleFileName);
    }

    private RefactoringStatus validateChangeToBaseName(String fileName) {
        String fileNameEnding;
        String newName = this.getArguments().getNewName();
        if (!newName.endsWith(PROPERTIES_EXT)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.MessageBundleRenameParticipant_LocaleOrExtChangeNotAllowed);
        }
        String localeSuffix = JsfRefactoringUtil.getLocaleSuffix(this.fileToRename);
        if (localeSuffix == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.MessageBundleRenameParticipant_cannotResolveLocale);
        }
        String string = fileNameEnding = localeSuffix.equals("") ? PROPERTIES_EXT : "_" + localeSuffix + PROPERTIES_EXT;
        if (!newName.endsWith(fileNameEnding)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.MessageBundleRenameParticipant_LocaleOrExtChangeNotAllowed);
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(Messages.MessageBundleRenameParticipant_renameLocalizedBundles);
        RefactoringUtil.createChangesForArtifactReferences((RefactoringProcessor)this.getProcessor(), (CompositeChange)compositeChange, this.referencesToProcess, (String)this.oldReferenceName, (String)this.newReferenceName, new HashMap());
        String newName = this.getArguments().getNewName();
        String fileToRenameEnding = this.getBundleFileSuffix(this.localeToBundleMap.get(this.fileToRename));
        String newBaseName = newName.substring(0, newName.length() - fileToRenameEnding.length());
        for (IFile messageBundle : this.localeToBundleMap.keySet()) {
            if (messageBundle.equals((Object)this.fileToRename)) continue;
            Locale locale = this.localeToBundleMap.get(messageBundle);
            String ending = this.getBundleFileSuffix(locale);
            RenameResourceChange renameChange = new RenameResourceChange(messageBundle.getFullPath(), String.valueOf(newBaseName) + ending);
            compositeChange.add((Change)renameChange);
        }
        return compositeChange;
    }

    private String getBundleFileSuffix(Locale locale) {
        if (locale.toString().equals("")) {
            return PROPERTIES_EXT;
        }
        return "_" + locale.toString() + PROPERTIES_EXT;
    }
}

