/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.refactoring.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.refactoring.BundleRefactoringUtil;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import oracle.eclipse.tools.common.services.refactoring.internal.CommonRenameArguments;
import oracle.eclipse.tools.webtier.jsf.refactoring.internal.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class MessageBundleKeyRenameParticipant
extends RenameParticipant {
    private ArtifactController controller = ArtifactControllerFactory.getController();
    private Map<IFile, TextFileChange> fileToChangeMap = new HashMap<IFile, TextFileChange>();
    private IFile mainBundleFile;
    private CommonRenameArguments arguments;
    private Set<IFile> bundles = new HashSet<IFile>();
    private CompositeChange localizedChange;
    private CompositeChange dependenciesChange;

    protected boolean initialize(Object element) {
        IFile file;
        IArtifact artifact = RefactoringUtil.elementToArtifact((Object)element);
        if (artifact instanceof ResourceArtifact && artifact.getLocation() != null && artifact.getLocation().getResource() instanceof IFile && BundleRefactoringUtil.isBundleFile((IResource)(file = (IFile)artifact.getLocation().getResource()))) {
            this.mainBundleFile = file;
            if (!(this.getArguments() instanceof CommonRenameArguments)) {
                return false;
            }
            this.arguments = (CommonRenameArguments)this.getArguments();
            Project project = (Project)file.getProject().getAdapter(Project.class);
            IAppLocalizer appService = (IAppLocalizer)project.getAppService(IAppLocalizer.class);
            Set allBaseNames = appService.getAllBaseNames();
            for (String baseName : allBaseNames) {
                Collection availableLocales = appService.getAvailableLocales(baseName);
                for (Locale locale : availableLocales) {
                    IBundleResource bundle = appService.resolveBundle(baseName, locale);
                    if (bundle == null) continue;
                    this.bundles.add(bundle.getUnderlyingResource());
                }
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return Messages.MessageBundleKeyRenameParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        Change change;
        int n;
        int n2;
        Change[] changeArray;
        String newProperty = this.getArguments().getNewName();
        RefactoringStatus status = new RefactoringStatus();
        if (newProperty.matches("[^\\s]*[\\s]+.*")) {
            status.addFatalError(NLS.bind((String)Messages.MessageBundleKeyRenameParticipant_theKeyIsNotWellFormed, (Object)(String.valueOf(Messages.MessageBundleKeyRenameParticipant_whiteSpace) + " \"" + newProperty + "\"")));
            return status;
        }
        if (newProperty.indexOf(61) > 0 || newProperty.indexOf(58) > 0) {
            status.addFatalError(NLS.bind((String)Messages.MessageBundleKeyRenameParticipant_theKeyIsNotWellFormed, (Object)(String.valueOf(Messages.MessageBundleKeyRenameParticipant_delimeters) + " \"" + newProperty + "\"")));
            return status;
        }
        if (newProperty.matches("[_\\.][a-zA-Z0-9_\\.]*") || newProperty.matches("[a-zA-Z][a-zA-Z0-9_.]*[a-zA-Z0-9][_\\.]")) {
            status.addFatalError(NLS.bind((String)Messages.MessageBundleKeyRenameParticipant_theKeyIsNotWellFormed, (Object)(String.valueOf(Messages.MessageBundleKeyRenameParticipant_startOrEnd) + " \"" + newProperty + "\"")));
            return status;
        }
        if (!newProperty.matches("[a-zA-Z][a-zA-Z0-9_.]*[a-zA-Z0-9]")) {
            status.addFatalError(NLS.bind((String)Messages.MessageBundleKeyRenameParticipant_theKeyIsNotWellFormed, (Object)(String.valueOf(Messages.MessageBundleKeyRenameParticipant_specialCharacters) + " \"" + newProperty + "\"")));
            return status;
        }
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        this.localizedChange = this.createLocalizedBundleChange();
        if (this.localizedChange.getChildren().length > 0) {
            changeArray = this.localizedChange.getChildren();
            n2 = changeArray.length;
            n = 0;
            while (n < n2) {
                change = changeArray[n];
                if (change instanceof TextFileChange) {
                    checker.getDeltaFactory().change(((TextFileChange)change).getFile());
                }
                ++n;
            }
        }
        this.dependenciesChange = this.createArtifactDependenciesChange();
        if (this.dependenciesChange.getChildren().length > 0) {
            changeArray = this.dependenciesChange.getChildren();
            n2 = changeArray.length;
            n = 0;
            while (n < n2) {
                change = changeArray[n];
                if (change instanceof TextFileChange) {
                    checker.getDeltaFactory().change(((TextFileChange)change).getFile());
                }
                ++n;
            }
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange = new CompositeChange(Messages.MessageBundleKeyRenameParticipant_additionalChanges);
        if (this.localizedChange.getChildren().length > 0) {
            compositeChange.add((Change)this.localizedChange);
        }
        if (this.dependenciesChange.getChildren().length > 0) {
            compositeChange.add((Change)this.dependenciesChange);
        }
        return compositeChange;
    }

    private CompositeChange createLocalizedBundleChange() {
        CompositeChange compositeChange = new CompositeChange(Messages.MessageBundleKeyRenameParticipant_renameKeysInLocalizedBundles);
        Object o = this.arguments.get("range");
        if (o instanceof Range) {
            Range range = (Range)o;
            String propertyToRename = RefactoringUtil.getRangeString((IFile)this.mainBundleFile, (Range)range);
            for (IFile bundle : this.bundles) {
                int startPosition;
                if (!bundle.equals((Object)this.mainBundleFile) && (startPosition = BundleRefactoringUtil.findPropertyNameStartPosition((IFile)bundle, (String)propertyToRename)) > 0) {
                    TextFileChange fileChange = new TextFileChange(this.getArguments().getNewName(), bundle);
                    ReplaceEdit edit = new ReplaceEdit(startPosition, propertyToRename.length(), this.getArguments().getNewName());
                    fileChange.setEdit((TextEdit)edit);
                    compositeChange.add((Change)fileChange);
                }
                this.updateFileToChangeMap(bundle, propertyToRename);
            }
        }
        return compositeChange;
    }

    private void updateFileToChangeMap(IFile file, String property) {
        ResourceArtifact artifact = DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)file);
        Set artifactReferences = this.controller.getArtifactReferers((IArtifact)artifact);
        HashMap<IFile, TextFileChange> map = new HashMap<IFile, TextFileChange>();
        for (IArtifactReference reference : artifactReferences) {
            for (IArtifactReferenceLocation location : reference.getLocations()) {
                Range localRange;
                IFile sourceFile;
                String rangeString;
                IResource resource;
                ResourceLocation resLocation = location.getResourceLocation();
                if (resLocation == null || !((resource = resLocation.getResource()) instanceof IFile) || (rangeString = RefactoringUtil.getRangeString((IFile)(sourceFile = (IFile)resource), (Range)(localRange = resLocation.getRange()))).indexOf(property) < 0) continue;
                TextFileChange fileChange = (TextFileChange)map.get(sourceFile);
                if (fileChange == null) {
                    fileChange = new TextFileChange(resource.getName(), sourceFile);
                    fileChange.setEdit((TextEdit)new MultiTextEdit());
                    map.put(sourceFile, fileChange);
                }
                String newProperty = this.getArguments().getNewName();
                ReplaceEdit edit = null;
                if (newProperty.indexOf(46) >= 0) {
                    ELExpression expression;
                    ValueReferenceELParser parser;
                    List expressions;
                    String expressionString = new String(rangeString);
                    if (rangeString.startsWith("\"") && rangeString.endsWith("\"")) {
                        expressionString = rangeString.substring(1);
                        expressionString = expressionString.substring(0, expressionString.length() - 1);
                    }
                    if ((expressions = (parser = new ValueReferenceELParser()).getExpressions((expression = parser.getSimpleELExpression(expressionString)).getElText())).size() > 0) {
                        ValueReferenceELParser.ValueReferenceELExpr expr = (ValueReferenceELParser.ValueReferenceELExpr)expressions.get(0);
                        String varName = expr.getModelObjectName();
                        StringBuffer newExpression = new StringBuffer("\"#{").append(varName).append("['").append(newProperty).append("']}\"");
                        edit = new ReplaceEdit((int)localRange.getOffset(), (int)localRange.getLength(), newExpression.toString());
                    }
                } else {
                    int start = (int)localRange.getOffset() + rangeString.indexOf(property);
                    edit = new ReplaceEdit(start, property.length(), newProperty);
                }
                if (edit == null) continue;
                fileChange.getEdit().addChild((TextEdit)edit);
            }
        }
        for (IFile sourceFile : map.keySet()) {
            this.fileToChangeMap.put(sourceFile, (TextFileChange)map.get(sourceFile));
        }
    }

    private CompositeChange createArtifactDependenciesChange() {
        CompositeChange compositeChange = new CompositeChange(Messages.MessageBundleKeyRenameParticipant_artifactDependencies);
        for (IFile file : this.fileToChangeMap.keySet()) {
            compositeChange.add((Change)this.fileToChangeMap.get(file));
        }
        return compositeChange;
    }
}

