/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.refactoring.internal;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.refactoring.BundleRefactoringUtil;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;

public class JsfRefactoringUtil {
    private static final String PROPERTIES = ".properties";

    public static String getFullyQualifiedFileName(IFile resource) {
        String fqn;
        Assert.isTrue((boolean)JavaUtil.isJavaPackage((IContainer)resource.getParent()));
        String packageName = JavaUtil.getPackageName((IContainer)resource.getParent());
        Assert.isNotNull((Object)packageName);
        String string = fqn = packageName.equals("") ? "" : String.valueOf(packageName) + ".";
        if (BundleRefactoringUtil.isBundleFile((IResource)resource)) {
            return String.valueOf(fqn) + JsfRefactoringUtil.extractBundleBasename(resource.getProject(), resource.getName());
        }
        String name = resource.getName();
        String ext = resource.getFileExtension();
        name = JsfRefactoringUtil.extractSuffix(name, "." + ext);
        return String.valueOf(fqn) + name;
    }

    public static String getFullyQualifiedFileName(IContainer folder, String name) {
        String fqn;
        Assert.isTrue((boolean)JavaUtil.isJavaPackage((IContainer)folder));
        String packageName = JavaUtil.getPackageName((IContainer)folder);
        Assert.isNotNull((Object)packageName);
        String string = fqn = packageName.equals("") ? "" : String.valueOf(packageName) + ".";
        if (name.endsWith(PROPERTIES)) {
            return String.valueOf(fqn) + JsfRefactoringUtil.extractBundleBasename(folder.getProject(), name);
        }
        return String.valueOf(fqn) + name;
    }

    public static String extractBundleBasename(IProject pr, String newBundleName) {
        String newBasename = newBundleName;
        if (newBasename.endsWith(PROPERTIES)) {
            IAppLocalizer appService;
            newBasename = JsfRefactoringUtil.extractSuffix(newBasename, PROPERTIES);
            Project project = (Project)pr.getAdapter(Project.class);
            if (project != null && (appService = (IAppLocalizer)project.getAppService(IAppLocalizer.class)) != null) {
                Set allBaseNames = appService.getAllBaseNames();
                for (String baseName : allBaseNames) {
                    Collection availableLocales = appService.getAvailableLocales(baseName);
                    for (Locale locale : availableLocales) {
                        String localeString = locale.toString();
                        if (localeString.equals("") || !newBasename.endsWith(localeString)) continue;
                        return JsfRefactoringUtil.extractSuffix(newBasename, "_" + localeString);
                    }
                }
            }
        }
        return newBasename;
    }

    public static String getLocaleSuffix(IFile file) {
        IAppLocalizer appService;
        Assert.isNotNull((Object)file);
        Project project = (Project)file.getProject().getAdapter(Project.class);
        if (project != null && (appService = (IAppLocalizer)project.getAppService(IAppLocalizer.class)) != null) {
            Set allBaseNames = appService.getAllBaseNames();
            for (String baseName : allBaseNames) {
                Collection availableLocales = appService.getAvailableLocales(baseName);
                for (Locale locale : availableLocales) {
                    IBundleResource resolveBundle = appService.resolveBundle(baseName, locale);
                    if (!file.equals((Object)resolveBundle.getUnderlyingResource())) continue;
                    return locale.toString();
                }
            }
        }
        return null;
    }

    private static String extractSuffix(String name, String suffix) {
        if (name.endsWith(suffix)) {
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }
}

